/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetBuilderImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetQueryImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentContinuation;
import org.sonatype.nexus.repository.content.fluent.internal.RepositoryContentUtil;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.GroupType;

public class FluentAssetsImpl
implements FluentAssets {
    private final ContentFacetSupport facet;
    private final AssetStore<?> assetStore;

    public FluentAssetsImpl(ContentFacetSupport facet, AssetStore<?> assetStore) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.assetStore = (AssetStore)((Object)Preconditions.checkNotNull(assetStore));
    }

    @Override
    public FluentAssetBuilder path(String path) {
        return new FluentAssetBuilderImpl(this.facet, this.assetStore, path);
    }

    @Override
    public FluentAsset with(Asset asset) {
        return asset instanceof FluentAsset ? (FluentAsset)asset : new FluentAssetImpl(this.facet, asset);
    }

    @Override
    public int count() {
        return this.doCount(null, null, null);
    }

    int doCount(@Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return this.assetStore.countAssets(this.facet.contentRepositoryId(), kind, filter, filterParams);
    }

    @Override
    public Continuation<FluentAsset> browse(int limit, String continuationToken) {
        return this.doBrowse(limit, continuationToken, null, null, null);
    }

    Continuation<FluentAsset> doBrowse(int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        Set<Integer> leafRepositoryIds;
        if (RepositoryContentUtil.isGroupRepository(this.facet.repository()) && !(leafRepositoryIds = RepositoryContentUtil.getLeafRepositoryIds(this.facet.repository())).isEmpty()) {
            return new FluentContinuation(this.assetStore.browseAssets(leafRepositoryIds, continuationToken, kind, filter, filterParams, limit), this::with);
        }
        return new FluentContinuation(this.assetStore.browseAssets(this.facet.contentRepositoryId(), continuationToken, kind, filter, filterParams, limit), this::with);
    }

    @Override
    public FluentQuery<FluentAsset> byKind(String kind) {
        return new FluentAssetQueryImpl(this, kind);
    }

    @Override
    public FluentQuery<FluentAsset> byFilter(String filter, Map<String, Object> filterParams) {
        return new FluentAssetQueryImpl(this, filter, filterParams);
    }

    @Override
    public Optional<FluentAsset> find(EntityId externalId) {
        return this.assetStore.readAsset(InternalIds.toInternalId(externalId)).filter(this::containedInRepository).map(asset -> new FluentAssetImpl(this.facet, (Asset)asset));
    }

    private boolean containedInRepository(Asset asset) {
        int expectedContentRepositoryId = InternalIds.contentRepositoryId(asset);
        if (expectedContentRepositoryId == this.facet.contentRepositoryId()) {
            return true;
        }
        if (this.facet.repository().getType() instanceof GroupType) {
            return ((GroupFacet)this.facet.repository().facet(GroupFacet.class)).allMembers().stream().map(InternalIds::contentRepositoryId).filter(Optional::isPresent).map(Optional::get).anyMatch(id -> id == expectedContentRepositoryId);
        }
        return false;
    }
}

