/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.MissingBlobException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetBuilderImpl;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.WrappedContent;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class FluentAssetImpl
implements FluentAsset,
WrappedContent<Asset> {
    private final ContentFacetSupport facet;
    private final Asset asset;

    public FluentAssetImpl(ContentFacetSupport facet, Asset asset) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.asset = (Asset)Preconditions.checkNotNull((Object)asset);
    }

    @Override
    public Repository repository() {
        return this.facet.repository();
    }

    @Override
    public String path() {
        return this.asset.path();
    }

    @Override
    public String kind() {
        return this.asset.kind();
    }

    @Override
    public Optional<Component> component() {
        return this.asset.component();
    }

    @Override
    public Optional<AssetBlob> blob() {
        return this.asset.blob();
    }

    @Override
    public boolean hasBlob() {
        return this.asset.hasBlob();
    }

    @Override
    public Optional<OffsetDateTime> lastDownloaded() {
        return this.asset.lastDownloaded();
    }

    @Override
    public NestedAttributesMap attributes() {
        return this.asset.attributes();
    }

    @Override
    public OffsetDateTime created() {
        return this.asset.created();
    }

    @Override
    public void created(OffsetDateTime lastUpdated) {
        this.facet.stores().assetStore.created(this, lastUpdated);
    }

    @Override
    public OffsetDateTime lastUpdated() {
        return this.asset.lastUpdated();
    }

    @Override
    public FluentAsset attributes(AttributeOperation change, String key, Object value) {
        this.facet.stores().assetStore.updateAssetAttributes(this.asset, new AttributeChangeSet(change, key, value));
        this.asset.blob().ifPresent(blob -> this.facet.blobMetadataStorage().attach(this.facet.stores().blobStore, blob.blobRef().getBlobId(), null, this.asset.attributes(), this.asset.blob().get().checksums()));
        return this;
    }

    @Override
    public FluentAsset attributes(AttributeChangeSet changes) {
        this.facet.stores().assetStore.updateAssetAttributes(this.asset, changes);
        this.asset.blob().ifPresent(blob -> this.facet.blobMetadataStorage().attach(this.facet.stores().blobStore, blob.blobRef().getBlobId(), null, this.asset.attributes(), blob.checksums()));
        return this;
    }

    @Override
    public FluentAsset attach(TempBlob blob) {
        return new FluentAssetBuilderImpl(this.facet, this.facet.stores().assetStore, this.asset).attach(blob);
    }

    @Override
    public FluentAsset attach(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return new FluentAssetBuilderImpl(this.facet, this.facet.stores().assetStore, this.asset).attach(blob, checksums);
    }

    @Override
    public FluentAsset attachIgnoringWritePolicy(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return new FluentAssetBuilderImpl(this.facet, this.facet.stores().assetStore, this.asset).attachIgnoringWritePolicy(blob, checksums);
    }

    @Override
    public Content download() {
        AssetBlob assetBlob = this.asset.blob().orElseThrow(() -> new IllegalStateException("No blob attached to " + this.asset.path()));
        BlobRef blobRef = assetBlob.blobRef();
        Blob blob = this.facet.stores().blobStore.get(blobRef.getBlobId());
        if (blob == null) {
            throw new MissingBlobException(blobRef);
        }
        Content content = new Content((Payload)new BlobPayload(blob, assetBlob.contentType()));
        AttributesMap contentAttributes = content.getAttributes();
        contentAttributes.set(Asset.class, (Object)this);
        if (this.attributes().contains("cache")) {
            contentAttributes.set(CacheInfo.class, (Object)CacheInfo.fromMap((AttributesMap)this.attributes("cache")));
        }
        if (this.attributes().contains("content")) {
            NestedAttributesMap contentHeaders = this.attributes("content");
            contentAttributes.set("last_modified", (Object)new DateTime(contentHeaders.get("last_modified")));
            contentAttributes.set("etag", contentHeaders.get("etag"));
        } else {
            BlobMetrics metrics = blob.getMetrics();
            contentAttributes.set("last_modified", (Object)metrics.getCreationTime());
            contentAttributes.set("etag", (Object)metrics.getSha1Hash());
        }
        return content;
    }

    @Override
    public FluentAsset markAsDownloaded() {
        this.facet.stores().assetStore.markAsDownloaded(this.asset);
        return this;
    }

    @Override
    public FluentAsset markAsCached(Payload content) {
        if (content instanceof Content) {
            AttributeChangeSet changes = new AttributeChangeSet();
            AttributesMap contentAttributes = ((Content)content).getAttributes();
            CacheInfo cacheInfo = (CacheInfo)contentAttributes.get(CacheInfo.class);
            if (cacheInfo != null) {
                FluentAssetImpl.markAsCached(changes, cacheInfo);
            }
            FluentAssetImpl.cacheContentHeaders(changes, contentAttributes);
            this.attributes(changes);
        }
        return this;
    }

    @Override
    public FluentAsset markAsCached(CacheInfo cacheInfo) {
        return FluentAssetImpl.markAsCached(this, cacheInfo);
    }

    private static <A extends FluentAttributes<A>> A markAsCached(A attributes, CacheInfo cacheInfo) {
        return attributes.withAttribute("cache", cacheInfo.toMap());
    }

    @Override
    public FluentAsset markAsStale() {
        return this.attributes(AttributeOperation.OVERLAY, "cache", ImmutableMap.of((Object)"cache_token", (Object)"invalidated"));
    }

    @Override
    public boolean isStale(CacheController cacheController) {
        CacheInfo cacheInfo = CacheInfo.fromMap((AttributesMap)this.attributes("cache"));
        return cacheInfo != null && cacheController.isStale(cacheInfo);
    }

    @Override
    public FluentAsset kind(String kind) {
        ((AssetData)this.asset).setKind(kind);
        this.facet.stores().assetStore.updateAssetKind(this.asset);
        return this;
    }

    @Override
    public boolean delete() {
        this.facet.checkDeleteAllowed(this.asset);
        return this.facet.stores().assetStore.deleteAsset(this.asset);
    }

    @Override
    public Asset unwrap() {
        return this.asset;
    }

    private static void cacheContentHeaders(FluentAttributes<?> attributes, AttributesMap contentAttributes) {
        ImmutableMap contentHeaders;
        ImmutableMap.Builder headerBuilder = ImmutableMap.builder();
        if (contentAttributes.contains("last_modified")) {
            headerBuilder.put((Object)"last_modified", (Object)contentAttributes.get("last_modified").toString());
        }
        if (contentAttributes.contains("etag")) {
            headerBuilder.put((Object)"etag", (Object)((String)contentAttributes.get("etag", String.class)));
        }
        if (!(contentHeaders = headerBuilder.build()).isEmpty()) {
            attributes.withAttribute("content", contentHeaders);
        } else {
            attributes.withoutAttribute("content");
        }
    }

    @Override
    public void blobCreated(OffsetDateTime blobCreated) {
        this.blob().ifPresent(assetBlob -> this.facet.stores().assetBlobStore.setBlobCreated((AssetBlob)assetBlob, blobCreated));
    }

    @Override
    public void lastDownloaded(OffsetDateTime lastDownloaded) {
        this.facet.stores().assetStore.lastDownloaded(this, lastDownloaded);
    }

    @Override
    public void lastUpdated(OffsetDateTime lastUpdated) {
        this.facet.stores().assetStore.lastUpdated(this, lastUpdated);
    }

    public String toString() {
        return this.asset.toString();
    }
}

