/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.common.time.UTC;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBlobAttach;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetImpl;
import org.sonatype.nexus.repository.content.store.AssetBlobData;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.payloads.AttachableBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class FluentAssetBuilderImpl
implements FluentAssetBuilder,
FluentAssetBlobAttach {
    private final ContentFacetSupport facet;
    private final AssetStore<?> assetStore;
    private final AssetData assetData;
    private Supplier<Blob> blobSupplier;
    private Map<HashAlgorithm, HashCode> checksums;
    private Blob blob;
    private Map<String, Object> attributes;

    public FluentAssetBuilderImpl(ContentFacetSupport facet, AssetStore<?> assetStore, String path) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.assetStore = (AssetStore)((Object)Preconditions.checkNotNull(assetStore));
        this.assetData = new AssetData();
        this.assetData.setRepositoryId(facet.contentRepositoryId());
        this.assetData.setPath((String)Preconditions.checkNotNull((Object)path));
        this.assetData.setKind("");
    }

    public FluentAssetBuilderImpl(ContentFacetSupport facet, AssetStore<?> assetStore, Asset asset) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.assetStore = (AssetStore)((Object)Preconditions.checkNotNull(assetStore));
        this.assetData = (AssetData)Preconditions.checkNotNull((Object)asset);
    }

    @Override
    public FluentAssetBuilder kind(String kind) {
        this.assetData.setKind((String)Preconditions.checkNotNull((Object)kind));
        return this;
    }

    @Override
    public FluentAssetBuilder component(Component component) {
        this.assetData.setComponent((Component)Preconditions.checkNotNull((Object)component));
        return this;
    }

    @Override
    public FluentAssetBuilder blob(TempBlob tempBlob) {
        this.blobSupplier = () -> this.makePermanent(tempBlob);
        this.checksums = tempBlob.getHashes();
        return this;
    }

    @Override
    public FluentAssetBuilder blob(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        this.blobSupplier = () -> blob;
        this.checksums = checksums;
        return this;
    }

    @Override
    public FluentAssetBuilder attributes(String key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public FluentAsset save() {
        if (this.attributes != null) {
            this.assetData.attributes().backing().putAll(this.attributes);
        }
        if (this.blobSupplier != null) {
            this.facet.checkAttachAllowed(this.findAsset().orElse(this.assetData));
            this.blob = this.blobSupplier.get();
        }
        Asset asset = this.assetStore.save(this::findAsset, this::createAsset, this::updateAsset, this::postTransaction);
        return new FluentAssetImpl(this.facet, asset);
    }

    @Override
    public Optional<FluentAsset> find() {
        return this.findAsset().map(theAsset -> new FluentAssetImpl(this.facet, (Asset)theAsset));
    }

    private Optional<Asset> findAsset() {
        return this.assetStore.readPath(this.facet.contentRepositoryId(), this.assetData.path());
    }

    private Asset createAsset() {
        if (this.blob != null) {
            this.assetData.setAssetBlob(this.getOrCreateAssetBlob(this.blob, this.checksums));
        }
        OffsetDateTime now = UTC.now();
        this.assetData.setLastUpdated(now);
        if (ProxyFacetSupport.isDownloading()) {
            this.assetData.setLastDownloaded(now);
        }
        this.assetStore.createAsset(this.assetData);
        return this.assetData;
    }

    private Asset updateAsset(Asset asset) {
        this.updateAssetBlob(asset);
        this.updateAssetAttributes(asset);
        return asset;
    }

    private Asset updateAssetBlob(Asset asset) {
        if (this.blob != null) {
            ((AssetData)asset).setAssetBlob(this.getOrCreateAssetBlob(this.blob, this.checksums));
            this.facet.stores().assetStore.updateAssetBlobLink(asset);
        }
        return asset;
    }

    private Asset updateAssetAttributes(Asset asset) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            AttributeChangeSet changeSet = new AttributeChangeSet();
            this.attributes.forEach((key, value) -> {
                AttributeChangeSet attributeChangeSet2 = changeSet.attributes(AttributeOperation.OVERLAY, (String)key, value);
            });
            this.facet.stores().assetStore.updateAssetAttributes(asset, changeSet);
        }
        return asset;
    }

    private void postTransaction(Asset asset) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            asset.blob().ifPresent(blob -> this.facet.blobMetadataStorage().attach(this.facet.stores().blobStore, blob.blobRef().getBlobId(), null, asset.attributes(), blob.checksums()));
        }
    }

    private Blob makePermanent(TempBlob tempBlob) {
        if (tempBlob instanceof AttachableBlob && !((AttachableBlob)tempBlob).isAttached()) {
            ((AttachableBlob)tempBlob).markAttached();
            return tempBlob.getBlob();
        }
        Blob blob = tempBlob.getBlob();
        ImmutableMap.Builder headerBuilder = ImmutableMap.builder();
        Map tempHeaders = blob.getHeaders();
        headerBuilder.put((Object)"Bucket.repo-name", (Object)((String)tempHeaders.get("Bucket.repo-name")));
        headerBuilder.put((Object)"BlobStore.blob-name", (Object)this.assetData.path());
        headerBuilder.put((Object)"BlobStore.created-by", (Object)((String)tempHeaders.get("BlobStore.created-by")));
        headerBuilder.put((Object)"BlobStore.created-by-ip", (Object)((String)tempHeaders.get("BlobStore.created-by-ip")));
        headerBuilder.put((Object)"BlobStore.content-type", (Object)this.facet.checkContentType(this.assetData, blob));
        Blob permanentBlob = this.facet.stores().blobStore.makeBlobPermanent(blob.getId(), (Map)headerBuilder.build());
        NestedAttributesMap componentAttributes = this.assetData.component().map(RepositoryContent::attributes).orElse(null);
        Map checksums = this.assetData.blob().map(AssetBlob::checksums).orElse(null);
        this.facet.blobMetadataStorage().attach(this.facet.stores().blobStore, permanentBlob.getId(), componentAttributes, this.assetData.attributes(), checksums);
        return permanentBlob;
    }

    private AssetBlob getOrCreateAssetBlob(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        BlobRef blobRef = this.blobRef(blob);
        return this.facet.stores().assetBlobStore.readAssetBlob(blobRef).orElseGet(() -> this.createAssetBlob(blobRef, blob, checksums));
    }

    private AssetBlobData createAssetBlob(BlobRef blobRef, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        BlobMetrics metrics = blob.getMetrics();
        Map headers = blob.getHeaders();
        AssetBlobData assetBlob = new AssetBlobData();
        assetBlob.setBlobRef(blobRef);
        assetBlob.setBlobSize(metrics.getContentSize());
        assetBlob.setContentType((String)headers.get("BlobStore.content-type"));
        assetBlob.setChecksums((Map)checksums.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((HashAlgorithm)e.getKey()).name(), e -> ((HashCode)e.getValue()).toString())));
        assetBlob.setBlobCreated(DateHelper.toOffsetDateTime((DateTime)metrics.getCreationTime()));
        assetBlob.setCreatedBy((String)headers.get("BlobStore.created-by"));
        assetBlob.setCreatedByIp((String)headers.get("BlobStore.created-by-ip"));
        this.facet.stores().assetBlobStore.createAssetBlob(assetBlob);
        return assetBlob;
    }

    private BlobRef blobRef(Blob blob) {
        return new BlobRef(this.facet.nodeName(), this.facet.stores().blobStoreName, blob.getId().asUniqueString());
    }

    @Override
    public FluentAsset attach(TempBlob tempBlob) {
        this.facet.checkAttachAllowed(this.assetData);
        return this.attachBlob(this.makePermanent(tempBlob), tempBlob.getHashes());
    }

    @Override
    public FluentAsset attach(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        this.facet.checkAttachAllowed(this.assetData);
        return this.attachBlob(blob, checksums);
    }

    @Override
    public FluentAsset attachIgnoringWritePolicy(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return this.attachBlob(blob, checksums);
    }

    private FluentAsset attachBlob(Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        this.blob = blob;
        this.checksums = checksums;
        this.updateAssetBlob(this.assetData);
        return new FluentAssetImpl(this.facet, this.assetData);
    }
}

