/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.facet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.ContentRepository;
import org.sonatype.nexus.repository.content.facet.AssetBlobValidator;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetDependencies;
import org.sonatype.nexus.repository.content.facet.ContentFacetStores;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentBlobs;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetsImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentBlobsImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentsImpl;
import org.sonatype.nexus.repository.content.store.ContentRepositoryData;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.storage.BlobMetadataStorage;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalStore;
import org.sonatype.nexus.validation.ConstraintViolations;

public abstract class ContentFacetSupport
extends FacetSupport
implements ContentFacet,
TransactionalStore<DataSession<?>> {
    private final FormatStoreManager formatStoreManager;
    private ContentFacetDependencies dependencies;
    private Config config;
    private ContentFacetStores stores;
    private FluentBlobs fluentBlobs;
    private FluentComponents fluentComponents;
    private FluentAssets fluentAssets;
    private EntityId configRepositoryId;
    private Integer contentRepositoryId;
    private AssetBlobValidator assetBlobValidator;

    protected ContentFacetSupport(FormatStoreManager formatStoreManager) {
        this.formatStoreManager = (FormatStoreManager)Preconditions.checkNotNull((Object)formatStoreManager);
    }

    @Inject
    @VisibleForTesting
    protected final void setDependencies(ContentFacetDependencies dependencies) {
        this.dependencies = (ContentFacetDependencies)Preconditions.checkNotNull((Object)dependencies);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, "storage", Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
        Config configToValidate = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "storage", Config.class);
        HashSet violations = new HashSet();
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateBlobStoreNotInGroup(configToValidate.blobStoreName)});
        ConstraintViolations.maybePropagate(violations, (Logger)this.log);
    }

    private ConstraintViolation<?> validateBlobStoreNotInGroup(String blobStoreName) {
        return this.dependencies.blobStoreManager.getParent(blobStoreName).map(groupName -> this.dependencies.constraintViolationFactory.createViolation(String.format("%s.blobStoreName", "storage"), String.format("Blob Store '%s' is a member of Blob Store Group '%s' and cannot be set as storage", blobStoreName, groupName))).orElse(null);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "storage", Config.class);
        this.log.debug("Config: {}", (Object)this.config);
        this.stores = new ContentFacetStores(this.dependencies.blobStoreManager, this.config.blobStoreName, this.formatStoreManager, this.config.dataStoreName);
        this.fluentBlobs = new FluentBlobsImpl(this, this.stores.blobStore);
        this.fluentComponents = new FluentComponentsImpl(this, this.stores.componentStore);
        this.fluentAssets = new FluentAssetsImpl(this, this.stores.assetStore);
    }

    protected void doStart() throws Exception {
        this.configRepositoryId = this.getRepository().getConfiguration().getRepositoryId();
        Preconditions.checkState((this.configRepositoryId != null ? 1 : 0) != 0, (Object)"Missing configRepositoryId");
        this.contentRepositoryId = this.stores.contentRepositoryStore.readContentRepository(this.configRepositoryId).orElseGet(this::createContentRepository).contentRepositoryId();
        Preconditions.checkState((this.contentRepositoryId != null ? 1 : 0) != 0, (Object)"Missing contentRepositoryId");
        this.assetBlobValidator = this.dependencies.assetBlobValidators.selectValidator(this.getRepository());
    }

    protected void doDestroy() throws Exception {
        this.config = null;
    }

    private final ContentRepository createContentRepository() {
        ContentRepositoryData contentRepository = this.newContentRepository();
        contentRepository.setConfigRepositoryId(this.configRepositoryId);
        this.stores.contentRepositoryStore.createContentRepository(contentRepository);
        return contentRepository;
    }

    protected final ContentRepository contentRepository() {
        return this.stores.contentRepositoryStore.readContentRepository(this.configRepositoryId).orElseThrow(() -> new IllegalStateException("Missing content repository for " + this.configRepositoryId));
    }

    @Transactional
    protected void doDelete() throws Exception {
        if (this.configRepositoryId != null) {
            this.stores.assetStore.deleteAssets(this.contentRepositoryId);
            this.stores.componentStore.deleteComponents(this.contentRepositoryId);
            this.stores.contentRepositoryStore.deleteContentRepository(this.configRepositoryId);
        }
    }

    @Override
    public final EntityId configRepositoryId() {
        return this.configRepositoryId;
    }

    @Override
    public final Integer contentRepositoryId() {
        return this.contentRepositoryId;
    }

    @Override
    public final NestedAttributesMap attributes() {
        return this.contentRepository().attributes();
    }

    @Override
    public final OffsetDateTime created() {
        return this.contentRepository().created();
    }

    @Override
    public final OffsetDateTime lastUpdated() {
        return this.contentRepository().lastUpdated();
    }

    @Override
    public final ContentFacet attributes(AttributeOperation change, String key, Object value) {
        this.stores.contentRepositoryStore.updateContentRepositoryAttributes(this.contentRepository(), change, key, value);
        return this;
    }

    @Override
    public final FluentBlobs blobs() {
        return this.fluentBlobs;
    }

    @Override
    public final FluentComponents components() {
        return this.fluentComponents;
    }

    @Override
    public final FluentAssets assets() {
        return this.fluentAssets;
    }

    public final DataSession<?> openSession() {
        return this.dependencies.dataSessionSupplier.openSession(this.config.dataStoreName);
    }

    public final Optional<ClientInfo> clientInfo() {
        return Optional.ofNullable(this.dependencies.clientInfoProvider.getCurrentThreadClientInfo());
    }

    public final String nodeName() {
        return this.dependencies.nodeAccess.getId();
    }

    public final BlobMetadataStorage blobMetadataStorage() {
        return this.dependencies.blobMetadataStorage;
    }

    public final Repository repository() {
        return this.getRepository();
    }

    public final ContentFacetStores stores() {
        return this.stores;
    }

    public final void checkAttachAllowed(Asset asset) {
        if (!asset.hasBlob()) {
            if (!this.writePolicy(asset).checkCreateAllowed()) {
                this.throwNotAllowed(asset, " is read-only");
            }
        } else if (!this.writePolicy(asset).checkUpdateAllowed()) {
            this.throwNotAllowed(asset, " cannot be updated");
        }
    }

    public final void checkDeleteAllowed(Asset asset) {
        if (asset.hasBlob() && !this.writePolicy(asset).checkDeleteAllowed()) {
            this.throwNotAllowed(asset, " cannot be deleted");
        }
    }

    private void throwNotAllowed(Asset asset, String reason) {
        throw new IllegalOperationException(String.valueOf(this.repository().getName()) + asset.path() + reason);
    }

    public final String checkContentType(Asset asset, Blob blob) {
        return this.determineContentType(asset, blob, this.config.strictContentTypeValidation);
    }

    protected WritePolicy writePolicy(Asset asset) {
        return Optional.ofNullable(this.config.writePolicy).orElse(WritePolicy.ALLOW);
    }

    protected String determineContentType(Asset asset, Blob blob, boolean strictValidation) {
        String contentType = (String)blob.getHeaders().get("BlobStore.content-type");
        return this.assetBlobValidator.determineContentType(strictValidation, () -> ((Blob)blob).getInputStream(), asset.path(), contentType);
    }

    protected ContentRepositoryData newContentRepository() {
        return new ContentRepositoryData();
    }

    @VisibleForTesting
    static class Config {
        @NotEmpty
        public String blobStoreName = "default";
        @NotEmpty
        public String dataStoreName = "nexus";
        @NotNull(groups={HostedType.ValidationGroup.class})
        public WritePolicy writePolicy;
        @NotNull
        public Boolean strictContentTypeValidation = Boolean.TRUE;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "blobStoreName='" + this.blobStoreName + '\'' + ", dataStoreName='" + this.dataStoreName + '\'' + ", writePolicy=" + this.writePolicy + ", strictContentTypeValidation=" + this.strictContentTypeValidation + '}';
        }
    }
}

