/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.facet;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.ContentRepositoryStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;

public class ContentFacetStores {
    public final String blobStoreName;
    public final BlobStore blobStore;
    public final String contentStoreName;
    public final ContentRepositoryStore<?> contentRepositoryStore;
    public final ComponentStore<?> componentStore;
    public final AssetStore<?> assetStore;
    public final AssetBlobStore<?> assetBlobStore;

    public ContentFacetStores(BlobStoreManager blobStoreManager, String blobStoreName, FormatStoreManager formatStoreManager, String contentStoreName) {
        this.blobStoreName = (String)Preconditions.checkNotNull((Object)blobStoreName);
        this.blobStore = blobStoreManager.get(blobStoreName);
        this.contentStoreName = (String)Preconditions.checkNotNull((Object)contentStoreName);
        this.contentRepositoryStore = formatStoreManager.contentRepositoryStore(contentStoreName);
        this.componentStore = formatStoreManager.componentStore(contentStoreName);
        this.assetStore = formatStoreManager.assetStore(contentStoreName);
        this.assetBlobStore = formatStoreManager.assetBlobStore(contentStoreName);
    }
}

