/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.facet;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryStartedEvent;
import org.sonatype.nexus.repository.RepositoryStoppedEvent;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;

@Named
@Singleton
public class ContentFacetFinder
extends ComponentSupport
implements EventAware {
    private final Map<String, Repository> repositoriesByContentId = new ConcurrentHashMap<String, Repository>();

    public Optional<Repository> findRepository(String format, RepositoryContent content) {
        return this.findRepository(format, InternalIds.contentRepositoryId(content));
    }

    public Optional<ContentFacet> findContentFacet(String format, RepositoryContent content) {
        return this.findContentFacet(format, InternalIds.contentRepositoryId(content));
    }

    public Optional<Repository> findRepository(String format, int contentRepositoryId) {
        return Optional.ofNullable(this.repositoriesByContentId.get(this.cacheKey(format, contentRepositoryId)));
    }

    public Optional<ContentFacet> findContentFacet(String format, int contentRepositoryId) {
        return this.findRepository(format, contentRepositoryId).map(r -> (ContentFacet)r.facet(ContentFacet.class));
    }

    public static Stream<ContentFacet> findContentFacets(Repository repository) {
        Optional contentFacet = repository.optionalFacet(ContentFacet.class);
        if (contentFacet.isPresent()) {
            return Stream.of((ContentFacet)contentFacet.get());
        }
        return repository.optionalFacet(GroupFacet.class).map(GroupFacet::members).orElse((List)ImmutableList.of()).stream().flatMap(ContentFacetFinder::findContentFacets);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryStartedEvent event) {
        Repository repository = event.getRepository();
        String format = repository.getFormat().getValue();
        repository.optionalFacet(ContentFacet.class).ifPresent(facet -> {
            Repository repository2 = this.repositoriesByContentId.put(this.cacheKey(format, facet.contentRepositoryId()), repository);
        });
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(RepositoryStoppedEvent event) {
        Repository repository = event.getRepository();
        String format = repository.getFormat().getValue();
        repository.optionalFacet(ContentFacet.class).ifPresent(facet -> {
            Repository repository = this.repositoriesByContentId.remove(this.cacheKey(format, facet.contentRepositoryId()));
        });
    }

    private String cacheKey(String format, int contentRepositoryId) {
        return String.valueOf(format) + ':' + contentRepositoryId;
    }
}

