/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.facet;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.AssetBlobValidator;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named
@Singleton
public class AssetBlobValidators {
    private final Map<String, MimeRulesSource> mimeRulesSources;
    private final Map<String, ContentValidator> contentValidators;
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public AssetBlobValidators(Map<String, MimeRulesSource> mimeRulesSources, Map<String, ContentValidator> contentValidators, DefaultContentValidator defaultContentValidator) {
        this.mimeRulesSources = (Map)Preconditions.checkNotNull(mimeRulesSources);
        this.contentValidators = (Map)Preconditions.checkNotNull(contentValidators);
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    public AssetBlobValidator selectValidator(Repository repository) {
        String format = repository.getFormat().getValue();
        MimeRulesSource mimeRulesSource = this.mimeRulesSources.getOrDefault(format, MimeRulesSource.NOOP);
        ContentValidator contentValidator = this.contentValidators.getOrDefault(format, (ContentValidator)this.defaultContentValidator);
        return (strict, contentSupplier, assetPath, declaredContentType) -> {
            try {
                return contentValidator.determineContentType(strict, contentSupplier, mimeRulesSource, assetPath, declaredContentType);
            }
            catch (IOException e) {
                throw new InvalidContentException((Throwable)e);
            }
        };
    }
}

