/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.director;

import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;

public interface ContentDirector {
    default public Component beforeMove(Component component, List<? extends Asset> assets, Repository source, Repository destination) {
        return component;
    }

    default public FluentComponent copyComponent(Component source, Repository destination) {
        ContentFacet content = (ContentFacet)destination.facet(ContentFacet.class);
        FluentComponentBuilder destComponentBuilder = content.components().name(source.name()).namespace(source.namespace()).version(source.version());
        source.attributes().forEach(attribute -> {
            FluentComponentBuilder fluentComponentBuilder2 = destComponentBuilder.attributes((String)attribute.getKey(), attribute.getValue());
        });
        return destComponentBuilder.getOrCreate();
    }

    default public Component afterMove(Component component, Repository destination) {
        return component;
    }

    default public boolean allowMoveTo(Repository destination) {
        return false;
    }

    default public boolean allowMoveTo(FluentComponent component, Repository destination) {
        return false;
    }

    default public boolean allowMoveFrom(Repository source) {
        return false;
    }

    default public void afterMove(List<Map<String, String>> components, Repository destination) {
    }
}

