/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse.store;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.store.InternalIds;

public class BrowseNodeData
implements BrowseNode {
    Integer nodeId;
    int repositoryId;
    private String requestPath;
    private String displayName;
    int parentId;
    private boolean leaf;
    @Nullable
    Integer dbComponentId;
    @Nullable
    Integer dbAssetId;
    @Nullable
    private String packageUrl;

    public String getPath() {
        return this.requestPath;
    }

    public String getName() {
        return this.displayName;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public EntityId getComponentId() {
        return this.dbComponentId != null ? InternalIds.toExternalId(this.dbComponentId) : null;
    }

    public EntityId getAssetId() {
        return this.dbAssetId != null ? InternalIds.toExternalId(this.dbAssetId) : null;
    }

    @Nullable
    public String getPackageUrl() {
        return this.packageUrl;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public void setRepositoryId(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = (String)Preconditions.checkNotNull((Object)requestPath);
    }

    public void setDisplayName(String displayName) {
        this.displayName = (String)Preconditions.checkNotNull((Object)displayName);
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setComponent(@Nullable Component component) {
        this.dbComponentId = component != null ? Integer.valueOf(InternalIds.internalComponentId(component)) : null;
    }

    public void setAsset(@Nullable Asset asset) {
        this.dbAssetId = asset != null ? Integer.valueOf(InternalIds.internalAssetId(asset)) : null;
    }

    public void setPackageUrl(@Nullable String packageUrl) {
        this.packageUrl = packageUrl;
    }
}

