/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class RebuildBrowseNodesManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private boolean rebuildOnStart = false;

    @Inject
    public RebuildBrowseNodesManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void setRebuildOnSart(boolean rebuildOnStart) {
        this.rebuildOnStart = rebuildOnStart;
    }

    protected void doStart() {
        if (!this.rebuildOnStart) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        try {
            boolean existingTask;
            String repositoryNames = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(this::hasAssets).map(Repository::getName).collect(Collectors.joining(","));
            if (!Strings2.isEmpty((String)repositoryNames) && !(existingTask = this.taskScheduler.findAndSubmit("create.browse.nodes", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repositoryNames)))) {
                this.launchNewTask(repositoryNames);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to determine if the browse nodes need to be rebuilt for any repositories", (Throwable)e);
        }
        this.log.debug("scheduling rebuild browse nodes tasks took {} ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean hasAssets(Repository repository) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().count() > 0;
    }

    private void launchNewTask(String repositoryNames) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("create.browse.nodes");
        configuration.setString("repositoryName", repositoryNames);
        configuration.setName("Rebuild repository browse tree - (" + repositoryNames + ")");
        this.taskScheduler.submit(configuration);
    }
}

