/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeDAO;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeManager;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeStore;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.ossindex.PackageUrlService;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class BrowseFacetImpl
extends FacetSupport
implements BrowseFacet {
    private final Map<String, FormatStoreManager> formatStoreManagersByFormat;
    private final Map<String, BrowseNodeGenerator> browseNodeGeneratorsByFormat;
    private final PackageUrlService packageUrlService;
    private final int pageSize;
    private String format;
    private BrowseNodeGenerator browseNodeGenerator;
    private BrowseNodeManager browseNodeManager;

    @Inject
    public BrowseFacetImpl(Map<String, FormatStoreManager> formatStoreManagersByFormat, Map<String, BrowseNodeGenerator> browseNodeGeneratorsByFormat, PackageUrlService packageUrlService, @Named(value="${nexus.browse.rebuild.pageSize:-1000}") int pageSize) {
        this.formatStoreManagersByFormat = (Map)Preconditions.checkNotNull(formatStoreManagersByFormat);
        this.browseNodeGeneratorsByFormat = (Map)Preconditions.checkNotNull(browseNodeGeneratorsByFormat);
        this.packageUrlService = (PackageUrlService)Preconditions.checkNotNull((Object)packageUrlService);
        this.pageSize = Math.max(pageSize, 1);
    }

    protected void doStart() throws Exception {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.getRepository().facet(ContentFacet.class);
        this.format = this.getRepository().getFormat().getValue();
        String storeName = contentFacet.stores().contentStoreName;
        int repositoryId = contentFacet.contentRepositoryId();
        BrowseNodeStore browseNodeStore = (BrowseNodeStore)((Object)this.lookupFormatStoreManager(this.format).formatStore(storeName, BrowseNodeDAO.class));
        this.browseNodeGenerator = this.lookupBrowseNodeGenerator(this.format);
        this.browseNodeManager = new BrowseNodeManager(browseNodeStore, repositoryId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<BrowseNode> getByDisplayPath(List<String> displayPath, int limit, String filter, Map<String, Object> filterParams) {
        return this.browseNodeManager.getByDisplayPath(displayPath, limit, filter, filterParams);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void addPathsToAssets(Collection<EntityId> assetIds) {
        FluentAssets lookup = ((ContentFacet)this.facet(ContentFacet.class)).assets();
        assetIds.stream().map(lookup::find).filter(Optional::isPresent).map(Optional::get).forEach(this::createBrowseNodes);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void trimBrowseNodes() {
        this.browseNodeManager.trimBrowseNodes();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void rebuildBrowseNodes() {
        this.log.info("Deleting browse nodes for repository {}", (Object)this.getRepository().getName());
        this.browseNodeManager.deleteBrowseNodes();
        this.log.info("Rebuilding browse nodes for repository {}", (Object)this.getRepository().getName());
        this.createBrowseNodes();
    }

    private void createBrowseNodes() {
        String repositoryName = this.getRepository().getName();
        try {
            FluentAssets assets = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets();
            long total = assets.count();
            if (total > 0L) {
                ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                Stopwatch sw = Stopwatch.createStarted();
                long processed = 0L;
                Continuation page = assets.browse(this.pageSize, null);
                while (!page.isEmpty()) {
                    page.forEach(this::createBrowseNodes);
                    long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                    progressLogger.info("Processed {} / {} {} assets in {} ms", new Object[]{processed += (long)page.size(), total, repositoryName, elapsed});
                    CancelableHelper.checkCancellation();
                    page = assets.browse(this.pageSize, page.nextContinuationToken());
                }
                progressLogger.flush();
            }
        }
        catch (Exception e) {
            this.log.error("Unable to rebuild browse nodes for repository {}", (Object)repositoryName, (Object)e);
        }
    }

    private void createBrowseNodes(FluentAsset asset) {
        if (!this.browseNodeManager.hasAssetNode(asset)) {
            List<BrowsePath> assetPaths = this.browseNodeGenerator.computeAssetPaths(asset);
            if (!assetPaths.isEmpty()) {
                this.browseNodeManager.createBrowseNodes(assetPaths, node -> node.setAsset(asset));
            }
        } else {
            this.log.debug("Skipping asset {}", (Object)asset.path());
        }
        asset.component().ifPresent(component -> {
            List<BrowsePath> componentPaths = this.browseNodeGenerator.computeComponentPaths(asset);
            if (!componentPaths.isEmpty()) {
                this.browseNodeManager.createBrowseNodes(componentPaths, node -> {
                    node.setComponent((Component)component);
                    this.findPackageUrl((Component)component).map(PackageUrl::toString).ifPresent(node::setPackageUrl);
                });
            }
        });
    }

    private Optional<PackageUrl> findPackageUrl(Component component) {
        return this.packageUrlService.getPackageUrl(this.format, component.namespace(), component.name(), component.version());
    }

    private FormatStoreManager lookupFormatStoreManager(String format) {
        FormatStoreManager storeManager = this.formatStoreManagersByFormat.get(format);
        Preconditions.checkState((storeManager != null ? 1 : 0) != 0, (String)"Could not find a store manager for format: %s", (Object)format);
        return storeManager;
    }

    private BrowseNodeGenerator lookupBrowseNodeGenerator(String format) {
        BrowseNodeGenerator generator = this.browseNodeGeneratorsByFormat.get(format);
        if (generator == null) {
            generator = this.browseNodeGeneratorsByFormat.get("default");
        }
        Preconditions.checkState((generator != null ? 1 : 0) != 0, (String)"Could not find a browse node generator for format: %s", (Object)format);
        return generator;
    }
}

