/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.fluent.FluentAttributes;

public class AttributeChangeSet
implements FluentAttributes<AttributeChangeSet> {
    private final List<AttributeChange> changes = new ArrayList<AttributeChange>();

    public AttributeChangeSet(AttributeOperation operation, String key, Object value) {
        this.changes.add(new AttributeChange(operation, key, value));
    }

    public AttributeChangeSet() {
    }

    @Override
    public AttributeChangeSet attributes(AttributeOperation change, String key, Object value) {
        this.changes.add(new AttributeChange(change, key, value));
        return this;
    }

    public List<AttributeChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public static class AttributeChange {
        private final AttributeOperation operation;
        private final String key;
        private final Object value;

        private AttributeChange(AttributeOperation operation, String key, @Nullable Object value) {
            this.operation = (AttributeOperation)((Object)Preconditions.checkNotNull((Object)((Object)operation)));
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.value = value;
        }

        public AttributeOperation getOperation() {
            return this.operation;
        }

        public String getKey() {
            return this.key;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "AttributeChange{operation=" + (Object)((Object)this.operation) + ", key='" + this.key + '\'' + ", value=" + this.value + "} ";
        }
    }
}

