/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketConfiguration;

public class S3BlobStoreApiModel {
    @NotNull
    @ApiModelProperty(value="The name of the S3 blob store.", example="s3", required=true)
    private String name;
    @ApiModelProperty(value="Settings to control the soft quota.")
    private final BlobStoreApiSoftQuota softQuota;
    @Valid
    @NotNull
    @ApiModelProperty(value="The S3 specific configuration details for the S3 object that'll contain the blob store.")
    private final S3BlobStoreApiBucketConfiguration bucketConfiguration;

    @JsonCreator
    public S3BlobStoreApiModel(@JsonProperty(value="name") String name, @JsonProperty(value="softQuota") BlobStoreApiSoftQuota softQuota, @JsonProperty(value="bucketConfiguration") S3BlobStoreApiBucketConfiguration bucketConfiguration) {
        this.name = name;
        this.softQuota = softQuota;
        this.bucketConfiguration = bucketConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public BlobStoreApiSoftQuota getSoftQuota() {
        return this.softQuota;
    }

    public S3BlobStoreApiBucketConfiguration getBucketConfiguration() {
        return this.bucketConfiguration;
    }

    @ApiModelProperty(value="The blob store type.", readOnly=true, example="S3")
    public String getType() {
        return "S3";
    }
}

