/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiAdvancedBucketConnection;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucket;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketSecurity;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiEncryption;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class S3BlobStoreApiBucketConfiguration {
    @Valid
    @NotNull
    @ApiModelProperty(value="Details of the S3 bucket such as name and region", required=true)
    private final S3BlobStoreApiBucket bucket;
    @ApiModelProperty(value="Security details for granting access the S3 API")
    private final S3BlobStoreApiBucketSecurity bucketSecurity;
    @ApiModelProperty(value="The type of encryption to use if any")
    private final S3BlobStoreApiEncryption encryption;
    @ApiModelProperty(value="A custom endpoint URL, signer type and whether path style access is enabled")
    private final S3BlobStoreApiAdvancedBucketConnection advancedBucketConnection;

    public S3BlobStoreApiBucketConfiguration(@JsonProperty(value="bucket") S3BlobStoreApiBucket bucket, @JsonProperty(value="security") S3BlobStoreApiBucketSecurity bucketSecurity, @JsonProperty(value="encryption") S3BlobStoreApiEncryption encryption, @JsonProperty(value="advancedConnection") S3BlobStoreApiAdvancedBucketConnection advancedBucketConnection) {
        this.bucket = bucket;
        this.bucketSecurity = bucketSecurity;
        this.encryption = encryption;
        this.advancedBucketConnection = advancedBucketConnection;
    }

    public S3BlobStoreApiBucket getBucket() {
        return this.bucket;
    }

    public S3BlobStoreApiBucketSecurity getBucketSecurity() {
        return this.bucketSecurity;
    }

    public S3BlobStoreApiEncryption getEncryption() {
        return this.encryption;
    }

    public S3BlobStoreApiAdvancedBucketConnection getAdvancedBucketConnection() {
        return this.advancedBucketConnection;
    }
}

