/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class S3BlobStoreApiUpdateValidation {
    private static final String BLOB_STORE_NAME = "name";
    static final String BLOB_STORE_NAME_UPDATE_ERROR_MESSAGE = "Renaming an S3 blob store name is not supported";
    static final String NON_EXISTENT_BLOB_STORE_ERROR_MESSAGE_FORMAT = "No S3 blob store called '%s'";
    static final String BLOB_STORE_TYPE_MISMATCH_ERROR_FORMAT = "Blob store %s is not an S3 blob store";
    private static final String COMMA = ",";
    private final BlobStoreManager blobStoreManager;

    @Inject
    public S3BlobStoreApiUpdateValidation(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    void validateUpdateRequest(S3BlobStoreApiModel s3BlobStoreApiModel, String blobStoreName) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean blobStoreExists = this.checkBlobStoreExists(blobStoreName, errors);
        this.checkBlobStoreNamesMatch(s3BlobStoreApiModel, blobStoreName, errors);
        if (blobStoreExists) {
            this.checkBlobStoreTypeIsS3(blobStoreName, errors);
        }
        if (!errors.isEmpty()) {
            throw new ValidationErrorsException(BLOB_STORE_NAME, String.join((CharSequence)COMMA, errors));
        }
    }

    private boolean checkBlobStoreExists(String blobStoreName, List<String> errors) {
        if (!this.blobStoreManager.exists(blobStoreName)) {
            errors.add(String.format(NON_EXISTENT_BLOB_STORE_ERROR_MESSAGE_FORMAT, blobStoreName));
            return false;
        }
        return true;
    }

    private void checkBlobStoreNamesMatch(S3BlobStoreApiModel s3BlobStoreApiModel, String blobStoreName, List<String> errors) {
        if (!StringUtils.equalsIgnoreCase((String)s3BlobStoreApiModel.getName(), (String)blobStoreName)) {
            errors.add(BLOB_STORE_NAME_UPDATE_ERROR_MESSAGE);
        }
    }

    private void checkBlobStoreTypeIsS3(String blobStoreName, List<String> errors) {
        if (this.existingBlobStoreIsNotS3(blobStoreName)) {
            errors.add(String.format(BLOB_STORE_TYPE_MISMATCH_ERROR_FORMAT, blobStoreName));
        }
    }

    private boolean existingBlobStoreIsNotS3(String blobStoreName) {
        return !Optional.ofNullable(this.blobStoreManager.get(blobStoreName)).map(BlobStore::getBlobStoreConfiguration).map(BlobStoreConfiguration::getType).filter(type -> StringUtils.equalsIgnoreCase((String)"S3", (String)type)).isPresent();
    }
}

