/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;

@Api(value="Blob store")
public interface S3BlobStoreApiResourceDoc {
    @ApiOperation(value="Create an S3 blob store")
    @ApiResponses(value={@ApiResponse(code=201, message="S3 blob store created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response createBlobStore(@Valid S3BlobStoreApiModel var1) throws Exception;

    @ApiOperation(value="Update an S3 blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=204, message="S3 blob store updated"), @ApiResponse(code=400, message="Specified S3 blob store doesn't exist"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void updateBlobStore(@Valid S3BlobStoreApiModel var1, @ApiParam(value="Name of the blob store to update") String var2) throws Exception;

    @ApiOperation(value="Get a S3 blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=S3BlobStoreApiModel.class), @ApiResponse(code=400, message="Specified S3 blob store doesn't exist"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public S3BlobStoreApiModel getBlobStore(@ApiParam(value="Name of the blob store configuration to fetch") String var1);
}

