/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.s3.rest.internal.S3BlobStoreApiConfigurationMapper;
import org.sonatype.nexus.blobstore.s3.rest.internal.S3BlobStoreApiModelMapper;
import org.sonatype.nexus.blobstore.s3.rest.internal.S3BlobStoreApiResourceDoc;
import org.sonatype.nexus.blobstore.s3.rest.internal.S3BlobStoreApiUpdateValidation;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class S3BlobStoreApiResource
extends ComponentSupport
implements Resource,
S3BlobStoreApiResourceDoc {
    private static final String UNKNOWN_BLOB_STORE_MSG_FORMAT = "\"Blob store %s doesn't exist.\"";
    private static final String NOT_AN_S3_BLOB_STORE_MSG_FORMAT = "\"%s is not an S3 blob store.\"";
    private final S3BlobStoreApiUpdateValidation s3BlobStoreApiUpdateValidation;
    private final BlobStoreManager blobStoreManager;

    public S3BlobStoreApiResource(BlobStoreManager blobStoreManager, S3BlobStoreApiUpdateValidation validation) {
        this.blobStoreManager = blobStoreManager;
        this.s3BlobStoreApiUpdateValidation = validation;
    }

    @Override
    @POST
    @RequiresAuthentication
    @Path(value="/s3")
    @RequiresPermissions(value={"nexus:blobstores:create"})
    public Response createBlobStore(@Valid S3BlobStoreApiModel request) {
        try {
            BlobStoreConfiguration blobStoreConfiguration = S3BlobStoreApiModelMapper.map(this.blobStoreManager.newConfiguration(), request);
            this.blobStoreManager.create(blobStoreConfiguration);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Exception e) {
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    @PUT
    @RequiresAuthentication
    @Path(value="/s3/{name}")
    @RequiresPermissions(value={"nexus:blobstores:update"})
    public void updateBlobStore(@Valid S3BlobStoreApiModel request, @PathParam(value="name") String blobStoreName) throws Exception {
        this.s3BlobStoreApiUpdateValidation.validateUpdateRequest(request, blobStoreName);
        if (this.isPasswordUntouched(request)) {
            BlobStore currentS3Blobstore = this.blobStoreManager.get(blobStoreName);
            request.getBucketConfiguration().getBucketSecurity().setSecretAccessKey(((Map)currentS3Blobstore.getBlobStoreConfiguration().getAttributes().get("s3")).get("secretAccessKey").toString());
        }
        try {
            BlobStoreConfiguration blobStoreConfiguration = S3BlobStoreApiModelMapper.map(this.blobStoreManager.newConfiguration(), request);
            this.blobStoreManager.update(blobStoreConfiguration);
        }
        catch (Exception e) {
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private boolean isPasswordUntouched(S3BlobStoreApiModel request) {
        return request.getBucketConfiguration() != null && request.getBucketConfiguration().getBucketSecurity() != null && PasswordPlaceholder.is((String)request.getBucketConfiguration().getBucketSecurity().getSecretAccessKey());
    }

    @Override
    @GET
    @RequiresAuthentication
    @Path(value="/s3/{name}")
    @RequiresPermissions(value={"nexus:blobstores:read"})
    public S3BlobStoreApiModel getBlobStore(@PathParam(value="name") String blobStoreName) {
        return this.fetchBlobStoreConfiguration(blobStoreName).orElseThrow(() -> new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(UNKNOWN_BLOB_STORE_MSG_FORMAT, blobStoreName), "application/json"));
    }

    private Optional<S3BlobStoreApiModel> fetchBlobStoreConfiguration(String blobStoreName) {
        Optional<S3BlobStoreApiModel> result = Optional.ofNullable(this.blobStoreManager.get(blobStoreName)).map(BlobStore::getBlobStoreConfiguration).map(this::ensureBlobStoreTypeIsS3).map(S3BlobStoreApiConfigurationMapper::map);
        if (result.isPresent() && this.isAuthenticationDataPresent(result.get())) {
            result.get().getBucketConfiguration().getBucketSecurity().setSecretAccessKey(PasswordPlaceholder.get());
        }
        return result;
    }

    private boolean isAuthenticationDataPresent(S3BlobStoreApiModel s3BlobStoreApiModel) {
        return s3BlobStoreApiModel.getBucketConfiguration().getBucketSecurity() != null && s3BlobStoreApiModel.getBucketConfiguration().getBucketSecurity().getAccessKeyId() != null && StringUtils.isNotEmpty((String)s3BlobStoreApiModel.getBucketConfiguration().getBucketSecurity().getAccessKeyId());
    }

    private BlobStoreConfiguration ensureBlobStoreTypeIsS3(BlobStoreConfiguration configuration) {
        String type = configuration.getType();
        if (!StringUtils.equalsIgnoreCase((String)"S3", (String)type)) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(NOT_AN_S3_BLOB_STORE_MSG_FORMAT, configuration.getName()), "application/json");
        }
        return configuration;
    }
}

