/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.blobstore.s3.S3BlobStoreConfigurationBuilder;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiAdvancedBucketConnection;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucket;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketConfiguration;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketSecurity;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiEncryption;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;

public final class S3BlobStoreApiModelMapper {
    public static final int ONE_MILLION = 1000000;

    public static BlobStoreConfiguration map(BlobStoreConfiguration blobStoreConfiguration, S3BlobStoreApiModel request) {
        BlobStoreApiSoftQuota softQuota;
        S3BlobStoreApiAdvancedBucketConnection advanced;
        S3BlobStoreApiEncryption encryption;
        Preconditions.checkNotNull((Object)blobStoreConfiguration);
        Preconditions.checkNotNull((Object)request);
        S3BlobStoreApiBucketConfiguration bucketConfiguration = (S3BlobStoreApiBucketConfiguration)Preconditions.checkNotNull((Object)request.getBucketConfiguration());
        S3BlobStoreApiBucket bucket = (S3BlobStoreApiBucket)Preconditions.checkNotNull((Object)bucketConfiguration.getBucket(), (Object)"Missing bucket configuration");
        S3BlobStoreConfigurationBuilder builder = S3BlobStoreConfigurationBuilder.builder(blobStoreConfiguration, request.getName()).bucket(bucket.getName()).region(bucket.getRegion()).expiration(bucket.getExpiration()).prefix(bucket.getPrefix());
        S3BlobStoreApiBucketSecurity bucketSecurity = bucketConfiguration.getBucketSecurity();
        if (bucketSecurity != null) {
            builder.accessKey(bucketSecurity.getAccessKeyId());
            builder.accessSecret(bucketSecurity.getSecretAccessKey());
            builder.assumeRole(bucketSecurity.getRole());
            builder.sessionTokenKey(bucketSecurity.getSessionToken());
        }
        if ((encryption = bucketConfiguration.getEncryption()) != null) {
            builder.encryptionKey(encryption.getEncryptionKey());
            builder.encryptionType(encryption.getEncryptionType());
        }
        if ((advanced = bucketConfiguration.getAdvancedBucketConnection()) != null) {
            builder.endpoint(advanced.getEndpoint());
            builder.signerType(advanced.getSignerType());
            builder.maxConnectionPool(advanced.getMaxConnectionPoolSize());
            builder.forcePathStyle(advanced.getForcePathStyle());
        }
        if ((softQuota = request.getSoftQuota()) != null) {
            builder.quotaConfig(softQuota.getType(), (Long)Preconditions.checkNotNull((Object)softQuota.getLimit(), (Object)"Missing quota limit") * 1000000L);
        }
        return builder.build();
    }
}

