/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import java.util.Objects;
import java.util.Optional;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiAdvancedBucketConnection;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucket;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketConfiguration;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiBucketSecurity;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiEncryption;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public final class S3BlobStoreApiConfigurationMapper {
    public static S3BlobStoreApiModel map(BlobStoreConfiguration configuration) {
        return new S3BlobStoreApiModel(configuration.getName(), S3BlobStoreApiConfigurationMapper.createSoftQuota(configuration), S3BlobStoreApiConfigurationMapper.createS3BlobStoreBucketConfiguration(configuration));
    }

    private static BlobStoreApiSoftQuota createSoftQuota(BlobStoreConfiguration configuration) {
        NestedAttributesMap softQuotaAttributes = configuration.attributes("blobStoreQuotaConfig");
        if (!softQuotaAttributes.isEmpty()) {
            String quotaType = S3BlobStoreApiConfigurationMapper.getValue(softQuotaAttributes, "quotaType");
            String quotaLimit = S3BlobStoreApiConfigurationMapper.getValue(softQuotaAttributes, "quotaLimitBytes");
            if (Objects.nonNull(quotaType) && Objects.nonNull(quotaLimit)) {
                BlobStoreApiSoftQuota blobStoreApiSoftQuota = new BlobStoreApiSoftQuota();
                blobStoreApiSoftQuota.setType(quotaType);
                blobStoreApiSoftQuota.setLimit(Long.valueOf(Long.parseLong(quotaLimit) / 1000000L));
                return blobStoreApiSoftQuota;
            }
        }
        return null;
    }

    private static String getValue(NestedAttributesMap attributes, String key) {
        return Objects.toString(attributes.get(key), null);
    }

    private static S3BlobStoreApiBucketConfiguration createS3BlobStoreBucketConfiguration(BlobStoreConfiguration configuration) {
        NestedAttributesMap s3BucketAttributes = configuration.attributes("s3");
        return new S3BlobStoreApiBucketConfiguration(S3BlobStoreApiConfigurationMapper.buildS3BlobStoreBucket(s3BucketAttributes), S3BlobStoreApiConfigurationMapper.buildS3BlobStoreBucketSecurity(s3BucketAttributes), S3BlobStoreApiConfigurationMapper.buildS3BlobStoreEncryption(s3BucketAttributes), S3BlobStoreApiConfigurationMapper.buildS3BlobStoreAdvancedBucketConnection(s3BucketAttributes));
    }

    private static S3BlobStoreApiBucket buildS3BlobStoreBucket(NestedAttributesMap attributes) {
        String expiration = S3BlobStoreApiConfigurationMapper.getValue(attributes, "expiration");
        return new S3BlobStoreApiBucket(S3BlobStoreApiConfigurationMapper.getValue(attributes, "region"), S3BlobStoreApiConfigurationMapper.getValue(attributes, "bucket"), S3BlobStoreApiConfigurationMapper.getValue(attributes, "prefix"), Integer.valueOf(Objects.nonNull(expiration) ? expiration : "0"));
    }

    private static S3BlobStoreApiBucketSecurity buildS3BlobStoreBucketSecurity(NestedAttributesMap attributes) {
        String sessionToken;
        String roleToAssume;
        String accessKeyId = S3BlobStoreApiConfigurationMapper.getValue(attributes, "accessKeyId");
        if (S3BlobStoreApiConfigurationMapper.iamCredentialsProvided(accessKeyId, roleToAssume = S3BlobStoreApiConfigurationMapper.getValue(attributes, "assumeRole"), sessionToken = S3BlobStoreApiConfigurationMapper.getValue(attributes, "sessionToken"))) {
            return new S3BlobStoreApiBucketSecurity(accessKeyId, null, roleToAssume, sessionToken);
        }
        return null;
    }

    private static boolean iamCredentialsProvided(String accessKeyId, String roleToAssume, String sessionToken) {
        return S3BlobStoreApiConfigurationMapper.anyNonNull(accessKeyId, roleToAssume, sessionToken);
    }

    private static S3BlobStoreApiEncryption buildS3BlobStoreEncryption(NestedAttributesMap s3BucketAttributes) {
        String encryptionType = S3BlobStoreApiConfigurationMapper.getValue(s3BucketAttributes, "encryption_type");
        String encryptionKey = S3BlobStoreApiConfigurationMapper.getValue(s3BucketAttributes, "encryption_key");
        if (S3BlobStoreApiConfigurationMapper.anyNonNull(encryptionKey, encryptionType)) {
            return new S3BlobStoreApiEncryption(encryptionType, encryptionKey);
        }
        return null;
    }

    private static S3BlobStoreApiAdvancedBucketConnection buildS3BlobStoreAdvancedBucketConnection(NestedAttributesMap attributes) {
        String endpoint = S3BlobStoreApiConfigurationMapper.getValue(attributes, "endpoint");
        String signerType = S3BlobStoreApiConfigurationMapper.getValue(attributes, "signertype");
        String forcePathStyle = S3BlobStoreApiConfigurationMapper.getValue(attributes, "forcepathstyle");
        Integer maxConnectionPoolSize = Optional.ofNullable(S3BlobStoreApiConfigurationMapper.getValue(attributes, "max_connection_pool_size")).filter(val -> !"".equals(val)).map(Integer::valueOf).orElse(null);
        if (S3BlobStoreApiConfigurationMapper.anyNonNull(endpoint, signerType, forcePathStyle, maxConnectionPoolSize)) {
            return new S3BlobStoreApiAdvancedBucketConnection(endpoint, signerType, Boolean.valueOf(forcePathStyle), maxConnectionPoolSize);
        }
        return null;
    }

    private static boolean anyNonNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

