/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal.encryption;

import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.s3.internal.encryption.S3Encrypter;

@Named(value="s3ManagedEncryption")
public class S3ManagedEncrypter
implements S3Encrypter {
    public static final String ID = "s3ManagedEncryption";
    public static final String NAME = "S3 Managed Encryption";

    @Override
    public <T extends InitiateMultipartUploadRequest> T addEncryption(T request) {
        this.setEncryption(() -> request.getObjectMetadata(), arg_0 -> request.setObjectMetadata(arg_0));
        return request;
    }

    @Override
    public <T extends AbstractPutObjectRequest> T addEncryption(T request) {
        this.setEncryption(() -> request.getMetadata(), arg_0 -> request.setMetadata(arg_0));
        return request;
    }

    @Override
    public <T extends CopyObjectRequest> T addEncryption(T request) {
        this.setEncryption(() -> request.getNewObjectMetadata(), arg_0 -> request.setNewObjectMetadata(arg_0));
        return request;
    }

    private void setEncryption(Supplier<ObjectMetadata> getter, Consumer<ObjectMetadata> setter) {
        ObjectMetadata objectMetadata = Optional.ofNullable(getter.get()).orElse(new ObjectMetadata());
        objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        setter.accept(objectMetadata);
    }
}

