/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal.encryption;

import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.s3.internal.encryption.S3Encrypter;

@Named(value="kmsManagedEncryption")
public class KMSEncrypter
implements S3Encrypter {
    public static final String ID = "kmsManagedEncryption";
    public static final String NAME = "KMS Managed Encryption";
    private final SSEAwsKeyManagementParams kmsParameters;

    public KMSEncrypter() {
        this(Optional.empty());
    }

    public KMSEncrypter(Optional<String> kmsId) {
        this.kmsParameters = ((Optional)Preconditions.checkNotNull(kmsId)).map(String::trim).filter(id -> !id.isEmpty()).map(SSEAwsKeyManagementParams::new).orElse(new SSEAwsKeyManagementParams());
    }

    @Override
    public <T extends InitiateMultipartUploadRequest> T addEncryption(T request) {
        request.setSSEAwsKeyManagementParams(this.kmsParameters);
        return request;
    }

    @Override
    public <T extends AbstractPutObjectRequest> T addEncryption(T request) {
        request.setSSEAwsKeyManagementParams(this.kmsParameters);
        return request;
    }

    @Override
    public <T extends CopyObjectRequest> T addEncryption(T request) {
        request.setSSEAwsKeyManagementParams(this.kmsParameters);
        return request;
    }
}

