/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.PerformanceLogger;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.blobstore.s3.internal.S3Uploader;

public class S3RawObjectAccess
implements RawObjectAccess {
    private static final int LIST_RAW_OBJECTS_MAX_KEYS = 1000;
    private final String bucket;
    private final String bucketPrefix;
    private final AmazonS3 s3;
    private final PerformanceLogger performanceLogger;
    private S3Uploader uploader;

    public S3RawObjectAccess(String bucket, String bucketPrefix, AmazonS3 s3, PerformanceLogger performanceLogger, S3Uploader uploader) {
        this.bucket = Objects.requireNonNull(bucket);
        this.bucketPrefix = Objects.requireNonNull(bucketPrefix);
        this.s3 = Objects.requireNonNull(s3);
        this.performanceLogger = Objects.requireNonNull(performanceLogger);
        this.uploader = Objects.requireNonNull(uploader);
    }

    public Stream<String> listRawObjects(@Nullable Path path) {
        String prefix = String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path, true);
        ObjectListing listing = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(prefix).withDelimiter("/").withMaxKeys(Integer.valueOf(1000)));
        ArrayList<String> rawObjects = new ArrayList<String>(this.listingToFilenames(listing));
        while (listing.isTruncated()) {
            listing = this.s3.listNextBatchOfObjects(listing);
            rawObjects.addAll(this.listingToFilenames(listing));
        }
        return rawObjects.stream().sorted();
    }

    private List<String> listingToFilenames(ObjectListing listing) {
        return listing.getObjectSummaries().stream().map(s -> {
            String key = s.getKey();
            return key.substring(key.lastIndexOf(47) + 1);
        }).collect(Collectors.toList());
    }

    @Nullable
    public InputStream getRawObject(Path path) {
        try {
            S3Object object = this.s3.getObject(this.bucket, String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path));
            return this.performanceLogger.maybeWrapForPerformanceLogging((InputStream)object.getObjectContent());
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void putRawObject(Path path, InputStream input) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = input;){
                this.uploader.upload(this.s3, this.bucket, String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path), in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean hasRawObject(Path path) {
        try {
            return this.s3.doesObjectExist(this.bucket, String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path));
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public void deleteRawObject(Path path) {
        this.s3.deleteObject(this.bucket, String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path));
    }

    public void deleteRawObjectsInPath(Path path) {
        String prefix = String.valueOf(this.bucketPrefix) + this.normalizeS3Path(path, true);
        ObjectListing listing = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(prefix).withDelimiter("/").withMaxKeys(Integer.valueOf(1000)));
        this.deleteObjectsInListing(listing);
        while (listing.isTruncated()) {
            listing = this.s3.listNextBatchOfObjects(listing);
            this.deleteObjectsInListing(listing);
        }
    }

    private void deleteObjectsInListing(ObjectListing listing) {
        List keys = listing.getObjectSummaries().stream().map(s -> new DeleteObjectsRequest.KeyVersion(s.getKey())).collect(Collectors.toList());
        this.s3.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keys));
    }

    private String normalizeS3Path(Path path) {
        return this.normalizeS3Path(path, false);
    }

    private String normalizeS3Path(Path path, boolean requireTrailingSlash) {
        if (path == null) {
            return "/";
        }
        String normalized = path.toString().replace("\\", "/");
        if (requireTrailingSlash && !normalized.endsWith("/")) {
            return String.valueOf(normalized) + "/";
        }
        return normalized;
    }
}

