/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.model.Region;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.SelectOption;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.formfields.FormField;

@Named(value="S3")
public class S3BlobStoreDescriptor
extends BlobStoreDescriptorSupport {
    private static final String DEFAULT_LABEL = "Default";
    private static final String S3_SIGNER = "S3SignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    public static final String TYPE = "S3";
    private final Map<String, List<SelectOption>> s3SelectOptions;
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreManager blobStoreManager;

    @Inject
    public S3BlobStoreDescriptor(BlobStoreQuotaService quotaService, BlobStoreManager blobStoreManager) {
        super(quotaService);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.s3SelectOptions = this.intializeSelectOptions();
    }

    public String getId() {
        return "s3";
    }

    public String getName() {
        return messages.name();
    }

    public List<FormField> getFormFields() {
        return Collections.emptyList();
    }

    public String customFormName() {
        return "nx-blobstore-settings-s3";
    }

    public void validateConfig(BlobStoreConfiguration config) {
        super.validateConfig(config);
        for (BlobStore existingBlobStore : this.blobStoreManager.browse()) {
            this.validateOverlappingBucketWithConfiguration(config, existingBlobStore.getBlobStoreConfiguration());
        }
    }

    public void sanitizeConfig(BlobStoreConfiguration config) {
        String bucketPrefix = (String)config.attributes("s3").get("prefix", String.class, (Object)"");
        config.attributes("s3").set("prefix", (Object)this.trimAndCollapseSlashes(bucketPrefix));
    }

    public Map<String, List<SelectOption>> getDropDownValues() {
        return this.s3SelectOptions;
    }

    private Map<String, List<SelectOption>> intializeSelectOptions() {
        return ImmutableMap.of((Object)"regions", this.getRegionOptions(), (Object)"encryptionTypes", this.getEncryptionTypes(), (Object)"signerTypes", this.getSignerTypes());
    }

    private List<SelectOption> getRegionOptions() {
        return (List)Stream.concat(Stream.of(new SelectOption("DEFAULT", DEFAULT_LABEL)), Arrays.stream(Region.values()).map(region -> new SelectOption(region.toAWSRegion().getName(), region.toAWSRegion().getName()))).collect(ImmutableList.toImmutableList());
    }

    private List<SelectOption> getSignerTypes() {
        return new ImmutableList.Builder().add((Object)new SelectOption("DEFAULT", DEFAULT_LABEL)).add((Object)new SelectOption(S3_SIGNER, S3_SIGNER)).add((Object)new SelectOption(S3_V4_SIGNER, S3_V4_SIGNER)).build();
    }

    private List<SelectOption> getEncryptionTypes() {
        return new ImmutableList.Builder().add((Object)new SelectOption("none", "None")).add((Object)new SelectOption("s3ManagedEncryption", "S3 Managed Encryption")).add((Object)new SelectOption("kmsManagedEncryption", "KMS Managed Encryption")).build();
    }

    private String trimAndCollapseSlashes(String prefix) {
        return Optional.ofNullable(prefix).filter(StringUtils::isNotBlank).map(s -> StringUtils.strip((String)s, (String)"/ ")).map(s -> s.replaceAll("/+", "/")).orElse(prefix);
    }

    private void validateOverlappingBucketWithConfiguration(BlobStoreConfiguration newConfig, BlobStoreConfiguration existingConfig) {
        String newName = newConfig.getName();
        String newBucket = (String)newConfig.attributes("s3").get("bucket", String.class, (Object)"");
        String newPrefix = (String)newConfig.attributes("s3").get("prefix", String.class, (Object)"");
        String newEndpoint = (String)newConfig.attributes("s3").get("endpoint", String.class, (Object)"");
        if (!existingConfig.getName().equals(newName) && existingConfig.getType().equals(TYPE)) {
            String existingBucket = (String)existingConfig.attributes("s3").get("bucket", String.class, (Object)"");
            String existingPrefix = (String)existingConfig.attributes("s3").get("prefix", String.class, (Object)"");
            String existingEndpoint = (String)existingConfig.attributes("s3").get("endpoint", String.class, (Object)"");
            if (newBucket.equals(existingBucket) && newEndpoint.equals(existingEndpoint) && this.prefixesOverlap(existingPrefix, newPrefix)) {
                String message = String.format("Blob Store '%s' is already using bucket '%s'", existingConfig.getName(), existingBucket);
                if (!newPrefix.isEmpty() || !existingPrefix.isEmpty()) {
                    message = String.valueOf(message) + String.format(" with prefix '%s'", existingPrefix);
                }
                if (!newEndpoint.isEmpty() || !existingEndpoint.isEmpty()) {
                    message = String.valueOf(message) + String.format(" on endpoint '%s'", existingEndpoint);
                }
                throw new ValidationException(message);
            }
        }
    }

    private boolean prefixesOverlap(String prefix1, String prefix2) {
        String prefix2WithDelimiters;
        String prefix1WithDelimiters = ("/" + prefix1 + "/").replaceAll("//", "/");
        return prefix1WithDelimiters.startsWith(prefix2WithDelimiters = ("/" + prefix2 + "/").replaceAll("//", "/")) || prefix2WithDelimiters.startsWith(prefix1WithDelimiters);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="S3")
        public String name();
    }
}

