/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.Tag;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.BlobSupport;
import org.sonatype.nexus.blobstore.CloudBlobStoreSupport;
import org.sonatype.nexus.blobstore.MetricsInputStream;
import org.sonatype.nexus.blobstore.StreamMetrics;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.blobstore.metrics.MonitoringBlobStoreMetrics;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaUsageChecker;
import org.sonatype.nexus.blobstore.s3.internal.AmazonS3Factory;
import org.sonatype.nexus.blobstore.s3.internal.BucketManager;
import org.sonatype.nexus.blobstore.s3.internal.S3AttributesLocation;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobAttributes;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStoreConfigurationHelper;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.s3.internal.S3Copier;
import org.sonatype.nexus.blobstore.s3.internal.S3PropertiesFile;
import org.sonatype.nexus.blobstore.s3.internal.S3RawObjectAccess;
import org.sonatype.nexus.blobstore.s3.internal.S3Uploader;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named(value="S3")
public class S3BlobStore
extends CloudBlobStoreSupport<S3AttributesLocation> {
    public static final String TYPE = "S3";
    public static final String CONFIG_KEY = "s3";
    public static final String BUCKET_KEY = "bucket";
    public static final String BUCKET_PREFIX_KEY = "prefix";
    public static final String ACCESS_KEY_ID_KEY = "accessKeyId";
    public static final String SECRET_ACCESS_KEY_KEY = "secretAccessKey";
    public static final String SESSION_TOKEN_KEY = "sessionToken";
    public static final String ASSUME_ROLE_KEY = "assumeRole";
    public static final String REGION_KEY = "region";
    public static final String ENDPOINT_KEY = "endpoint";
    public static final String EXPIRATION_KEY = "expiration";
    public static final String SIGNERTYPE_KEY = "signertype";
    public static final String FORCE_PATH_STYLE_KEY = "forcepathstyle";
    public static final String MAX_CONNECTION_POOL_KEY = "max_connection_pool_size";
    public static final String ENCRYPTION_TYPE = "encryption_type";
    public static final String ENCRYPTION_KEY = "encryption_key";
    public static final String BUCKET_REGEX = "^([a-z]|(\\d(?!\\d{0,2}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})))([a-z\\d]|(\\.(?!(\\.|-)))|(-(?!\\.))){1,61}[a-z\\d]$";
    public static final int DEFAULT_EXPIRATION_IN_DAYS = 3;
    public static final int NO_AUTOMATIC_EXPIRY_HARD_DELETE = 0;
    public static final String METADATA_FILENAME = "metadata.properties";
    public static final String TYPE_KEY = "type";
    public static final String TYPE_V1 = "s3/1";
    private static final String CONTENT_PREFIX = "content";
    public static final String DIRECT_PATH_PREFIX = "content/directpath";
    public static final Tag DELETED_TAG = new Tag("deleted", "true");
    private static final String FILE_V1 = "file/1";
    private final AmazonS3Factory amazonS3Factory;
    private final BucketManager bucketManager;
    private S3Uploader uploader;
    private S3Copier copier;
    private boolean preferExpire;
    private boolean forceHardDelete;
    private boolean preferAsyncCleanup;
    private S3BlobStoreMetricsService storeMetrics;
    private BlobStoreQuotaUsageChecker blobStoreQuotaUsageChecker;
    private LoadingCache<BlobId, S3Blob> liveBlobs;
    private AmazonS3 s3;
    private ExecutorService executorService;
    private static final String METRIC_NAME = "s3Blobstore";
    private final Timer existsTimer;
    private final Timer expireTimer;
    private final Timer hardDeleteTimer;
    private RawObjectAccess rawObjectAccess;

    @Inject
    public S3BlobStore(AmazonS3Factory amazonS3Factory, BlobIdLocationResolver blobIdLocationResolver, @Named(value="${nexus.s3.uploaderName:-producerConsumerUploader}") S3Uploader uploader, @Named(value="${nexus.s3.copierName:-parallelCopier}") S3Copier copier, @Named(value="${nexus.s3.preferExpire:-false}") boolean preferExpire, @Named(value="${nexus.s3.forceHardDelete:-false}") boolean forceHardDelete, @Named(value="${nexus.s3.preferAsyncCleanup:-true}") boolean preferAsyncCleanup, S3BlobStoreMetricsService storeMetrics, DryRunPrefix dryRunPrefix, BucketManager bucketManager, BlobStoreQuotaUsageChecker blobStoreQuotaUsageChecker) {
        super(blobIdLocationResolver, dryRunPrefix);
        this.amazonS3Factory = (AmazonS3Factory)((Object)Preconditions.checkNotNull((Object)((Object)amazonS3Factory)));
        this.copier = (S3Copier)Preconditions.checkNotNull((Object)copier);
        this.uploader = (S3Uploader)Preconditions.checkNotNull((Object)uploader);
        this.storeMetrics = (S3BlobStoreMetricsService)Preconditions.checkNotNull((Object)storeMetrics);
        this.blobStoreQuotaUsageChecker = (BlobStoreQuotaUsageChecker)Preconditions.checkNotNull((Object)blobStoreQuotaUsageChecker);
        this.bucketManager = (BucketManager)((Object)Preconditions.checkNotNull((Object)((Object)bucketManager)));
        this.preferExpire = preferExpire;
        this.forceHardDelete = forceHardDelete;
        this.preferAsyncCleanup = preferAsyncCleanup;
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"nexus");
        this.existsTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "exists"}));
        this.expireTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "expire"}));
        this.hardDeleteTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "hardDelete"}));
    }

    protected void doStart() throws Exception {
        S3PropertiesFile metadata = new S3PropertiesFile(this.s3, this.getConfiguredBucket(), this.metadataFilePath());
        if (metadata.exists()) {
            metadata.load();
            String type = metadata.getProperty(TYPE_KEY);
            Preconditions.checkState((TYPE_V1.equals(type) || FILE_V1.equals(type) ? 1 : 0) != 0, (String)"Unsupported blob store type/version: %s in %s", (Object)type, (Object)((Object)metadata));
        } else {
            metadata.setProperty(TYPE_KEY, TYPE_V1);
            metadata.store();
        }
        this.liveBlobs = CacheBuilder.newBuilder().weakValues().build(CacheLoader.from(arg_0 -> S3Blob.new(this, arg_0)));
        this.storeMetrics.setBucket(this.getConfiguredBucket());
        this.storeMetrics.setBucketPrefix(this.getBucketPrefix());
        this.storeMetrics.setS3(this.s3);
        this.storeMetrics.setBlobStore((BlobStore)this);
        this.storeMetrics.start();
        this.blobStoreQuotaUsageChecker.setBlobStore((BlobStore)this);
        this.blobStoreQuotaUsageChecker.start();
        if (this.preferAsyncCleanup && this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(8, (ThreadFactory)new NexusThreadFactory("s3-blobstore", "async-ops"));
        }
    }

    protected void doStop() throws Exception {
        this.liveBlobs = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.storeMetrics.stop();
        this.blobStoreQuotaUsageChecker.stop();
    }

    private String contentPath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".bytes";
    }

    private String metadataFilePath() {
        return String.valueOf(this.getBucketPrefix()) + METADATA_FILENAME;
    }

    private String attributePath(BlobId id) {
        return String.valueOf(this.getLocation(id)) + ".properties";
    }

    protected String attributePathString(BlobId blobId) {
        return this.attributePath(blobId);
    }

    private String getLocation(BlobId id) {
        return String.valueOf(this.getContentPrefix()) + this.blobIdLocationResolver.getLocation(id);
    }

    @Timed
    @MonitoringBlobStoreMetrics(operationType=OperationType.UPLOAD)
    protected Blob doCreate(InputStream blobData, Map<String, String> headers, @Nullable BlobId blobId) {
        return this.create(headers, destination -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream data = blobData;){
                MetricsInputStream input = new MetricsInputStream(data);
                this.uploader.upload(this.s3, this.getConfiguredBucket(), destination, (InputStream)input);
                return input.getMetrics();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, blobId);
    }

    @Guarded(by={"STARTED"})
    @Timed
    public Blob create(Path sourceFile, Map<String, String> headers, long size, HashCode sha1) {
        throw new BlobStoreException("hard links not supported", null);
    }

    @Timed
    private Blob create(Map<String, String> headers, BlobIngester ingester, @Nullable BlobId assignedBlobId) {
        BlobId blobId = this.getBlobId(headers, assignedBlobId);
        String blobPath = this.contentPath(blobId);
        String attributePath = this.attributePath(blobId);
        boolean isDirectPath = Boolean.parseBoolean(headers.getOrDefault("BlobStore.direct-path", "false"));
        Long existingSize = null;
        if (isDirectPath) {
            S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), attributePath);
            if (this.exists(blobId)) {
                existingSize = this.getContentSizeForDeletion(blobAttributes);
            }
        }
        S3Blob blob = (S3Blob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            this.log.debug("Writing blob {} to {}", (Object)blobId, (Object)blobPath);
            StreamMetrics streamMetrics = ingester.ingestTo(blobPath);
            BlobMetrics metrics = new BlobMetrics(new DateTime(), streamMetrics.getSha1(), streamMetrics.getSize());
            blob.refresh(headers, metrics);
            S3BlobAttributes blobAttributes = this.writeBlobAttributes(headers, attributePath, metrics);
            if (isDirectPath && existingSize != null) {
                this.storeMetrics.recordDeletion(existingSize);
            }
            this.storeMetrics.recordAddition(blobAttributes.getMetrics().getContentSize());
            S3Blob s3Blob = blob;
            return s3Blob;
        }
        catch (IOException e) {
            this.deleteQuietly(attributePath);
            this.deleteQuietly(blobPath);
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    @Guarded(by={"STARTED"})
    @Timed
    public Blob copy(BlobId blobId, Map<String, String> headers) {
        Blob sourceBlob = (Blob)Preconditions.checkNotNull((Object)this.get(blobId));
        String sourcePath = this.contentPath(sourceBlob.getId());
        return this.create(headers, destination -> {
            this.copier.copy(this.s3, this.getConfiguredBucket(), sourcePath, destination);
            BlobMetrics metrics = sourceBlob.getMetrics();
            return new StreamMetrics(metrics.getContentSize(), metrics.getSha1Hash());
        }, null);
    }

    @Guarded(by={"STARTED"})
    @Timed
    public Blob writeBlobProperties(BlobId blobId, Map<String, String> headers) {
        S3Blob blob = (S3Blob)((Object)Preconditions.checkNotNull((Object)this.get(blobId)));
        String blobPath = this.contentPath(blob.getId());
        String attributePath = this.attributePath(blobId);
        BlobMetrics metrics = blob.getMetrics();
        Lock lock = blob.lock();
        try {
            this.log.debug("Attempting to make blob with id: {} and path: {} permanent.", (Object)blobId, (Object)blobPath);
            blob.refresh(headers, metrics);
            this.writeBlobAttributes(headers, attributePath, metrics);
            S3Blob s3Blob = blob;
            return s3Blob;
        }
        catch (IOException e) {
            this.deleteQuietly(attributePath);
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public Blob get(BlobId blobId) {
        return this.get(blobId, false);
    }

    @Nullable
    @Timed
    @MonitoringBlobStoreMetrics(operationType=OperationType.DOWNLOAD)
    public Blob get(BlobId blobId, boolean includeDeleted) {
        Preconditions.checkNotNull((Object)blobId);
        this.log.debug("Accessing blob {}", (Object)blobId);
        S3Blob blob = (S3Blob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        if (blob.isStale()) {
            return this.refreshBlob(blob, blobId, includeDeleted);
        }
        return blob;
    }

    @Timed
    private S3Blob refreshBlob(S3Blob blob, BlobId blobId, boolean includeDeleted) {
        Lock lock = blob.lock();
        try {
            if (blob.isStale()) {
                S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), this.attributePath(blobId));
                boolean loaded = blobAttributes.load();
                if (!loaded) {
                    this.log.warn("Attempt to access non-existent blob {} ({})", (Object)blobId, (Object)blobAttributes);
                    return null;
                }
                if (blobAttributes.isDeleted() && !includeDeleted) {
                    this.log.warn("Attempt to access soft-deleted blob {} attributes: {}", (Object)blobId, (Object)blobAttributes);
                    return null;
                }
                blob.refresh(blobAttributes.getHeaders(), blobAttributes.getMetrics());
                S3Blob s3Blob = blob;
                return s3Blob;
            }
            S3Blob s3Blob = blob;
            return s3Blob;
        }
        catch (IOException e) {
            throw new BlobStoreException((Throwable)e, blobId);
        }
        finally {
            lock.unlock();
        }
    }

    @Timed
    protected boolean doDelete(BlobId blobId, String reason) {
        if (this.forceHardDelete) {
            return this.performHardDelete(blobId);
        }
        if (this.deleteByExpire()) {
            return this.expire(blobId, reason);
        }
        return this.performHardDelete(blobId);
    }

    private boolean deleteByExpire() {
        return S3BlobStoreConfigurationHelper.getConfiguredExpirationInDays(this.blobStoreConfiguration) != 0;
    }

    /*
     * Exception decompiling
     */
    @Timed
    private boolean expire(BlobId blobId, String reason) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SetObjectTaggingRequest tagAsDeleted(String key) {
        return new SetObjectTaggingRequest(this.getConfiguredBucket(), key, new ObjectTagging(Collections.singletonList(DELETED_TAG)));
    }

    private SetObjectTaggingRequest untagAsDeleted(String key) {
        return new SetObjectTaggingRequest(this.getConfiguredBucket(), key, new ObjectTagging(Collections.emptyList()));
    }

    protected boolean doDeleteHard(BlobId blobId) {
        if (this.forceHardDelete) {
            return this.performHardDelete(blobId);
        }
        if (this.preferExpire && this.deleteByExpire()) {
            return this.expire(blobId, "hard-delete");
        }
        return this.performHardDelete(blobId);
    }

    @Timed
    private boolean performHardDelete(BlobId blobId) {
        S3Blob blob = (S3Blob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        Lock lock = blob.lock();
        try {
            boolean bl;
            block14: {
                Throwable throwable = null;
                Object var5_6 = null;
                Timer.Context performHardDeleteContext = this.hardDeleteTimer.time();
                try {
                    this.log.debug("Hard deleting blob {}", (Object)blobId);
                    String attributePath = this.attributePath(blobId);
                    S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), attributePath);
                    Long contentSize = this.getContentSizeForDeletion(blobAttributes);
                    String blobPath = this.contentPath(blobId);
                    boolean blobDeleted = this.batchDelete(blobPath, attributePath);
                    if (blobDeleted && contentSize != null) {
                        this.storeMetrics.recordDeletion(contentSize);
                    }
                    bl = blobDeleted;
                    if (performHardDeleteContext == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (performHardDeleteContext != null) {
                            performHardDeleteContext.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                performHardDeleteContext.close();
            }
            return bl;
        }
        finally {
            lock.unlock();
            this.liveBlobs.invalidate((Object)blobId);
        }
    }

    @Nullable
    @Timed
    private Long getContentSizeForDeletion(S3BlobAttributes blobAttributes) {
        try {
            blobAttributes.load();
            return blobAttributes.getMetrics() != null ? Long.valueOf(blobAttributes.getMetrics().getContentSize()) : null;
        }
        catch (Exception e) {
            this.log.warn("Unable to load attributes {}, delete will not be added to metrics.", (Object)blobAttributes, (Object)e);
            return null;
        }
    }

    @Guarded(by={"STARTED"})
    @Timed
    public BlobStoreMetrics getMetrics() {
        return this.storeMetrics.getMetrics();
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsByType() {
        return this.storeMetrics.getOperationMetrics();
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return this.storeMetrics.getOperationMetricsDelta();
    }

    public void clearOperationMetrics() {
        this.storeMetrics.clearOperationMetrics();
    }

    protected void doInit(BlobStoreConfiguration configuration) {
        try {
            this.s3 = this.amazonS3Factory.create(configuration);
            this.bucketManager.setS3(this.s3);
            this.bucketManager.prepareStorageLocation(this.blobStoreConfiguration);
            S3BlobStoreConfigurationHelper.setConfiguredBucket(this.blobStoreConfiguration, this.getConfiguredBucket());
            this.rawObjectAccess = new S3RawObjectAccess(this.getConfiguredBucket(), this.getBucketPrefix(), this.s3, this.performanceLogger, this.uploader);
        }
        catch (AmazonS3Exception e) {
            throw S3BlobStoreException.buildException(e);
        }
        catch (S3BlobStoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BlobStoreException("Unable to initialize blob store bucket: " + this.getConfiguredBucket(), (Throwable)e, null);
        }
    }

    private boolean batchDelete(String ... paths) {
        DeleteObjectsRequest request = new DeleteObjectsRequest(this.getConfiguredBucket()).withKeys(paths);
        return this.s3.deleteObjects(request).getDeletedObjects().size() == paths.length;
    }

    private void deleteQuietly(String path) {
        this.s3.deleteObject(this.getConfiguredBucket(), path);
    }

    private String getConfiguredBucket() {
        return S3BlobStoreConfigurationHelper.getConfiguredBucket(this.blobStoreConfiguration);
    }

    private String getBucketPrefix() {
        return S3BlobStoreConfigurationHelper.getBucketPrefix(this.blobStoreConfiguration);
    }

    private String getContentPrefix() {
        String bucketPrefix = this.getBucketPrefix();
        if (Strings.isNullOrEmpty((String)bucketPrefix)) {
            return "content/";
        }
        return String.valueOf(bucketPrefix) + CONTENT_PREFIX + "/";
    }

    @Guarded(by={"NEW", "STOPPED", "FAILED", "SHUTDOWN"})
    public void remove() {
        try {
            this.storeMetrics.remove();
            boolean contentEmpty = this.s3.listObjects(this.getConfiguredBucket(), this.getContentPrefix()).getObjectSummaries().isEmpty();
            if (contentEmpty) {
                S3PropertiesFile metadata = new S3PropertiesFile(this.s3, this.getConfiguredBucket(), this.metadataFilePath());
                metadata.remove();
                this.bucketManager.deleteStorageLocation(this.getBlobStoreConfiguration());
            } else {
                this.log.warn("Unable to delete non-empty blob store content directory in bucket {}", (Object)this.getConfiguredBucket());
                this.s3.deleteBucketLifecycleConfiguration(this.getConfiguredBucket());
            }
        }
        catch (AmazonS3Exception s3Exception) {
            if ("BucketNotEmpty".equals(s3Exception.getErrorCode())) {
                this.log.warn("Unable to delete non-empty blob store bucket {}", (Object)this.getConfiguredBucket());
            }
            throw new BlobStoreException((Throwable)s3Exception, null);
        }
        catch (IOException e) {
            throw new BlobStoreException((Throwable)e, null);
        }
    }

    @Timed
    public Stream<BlobId> getBlobIdStream() {
        S3Objects summaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.getConfiguredBucket(), (String)this.getContentPrefix());
        return this.blobIdStream(StreamSupport.stream(summaries.spliterator(), false));
    }

    public Stream<BlobId> getBlobIdUpdatedSinceStream(int sinceDays) {
        if (sinceDays < 0) {
            throw new IllegalArgumentException("sinceDays must >= 0");
        }
        S3Objects summaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.getConfiguredBucket(), (String)this.getContentPrefix());
        OffsetDateTime offsetDateTime = Instant.now().minus(sinceDays, ChronoUnit.DAYS).atOffset(ZoneOffset.UTC);
        return this.blobIdStream(StreamSupport.stream(summaries.spliterator(), false).filter(s3objectSummary -> s3objectSummary.getLastModified().toInstant().atOffset(ZoneOffset.UTC).isAfter(offsetDateTime)));
    }

    @Timed
    public Stream<BlobId> getDirectPathBlobIdStream(String prefix) {
        String subpath = String.valueOf(this.getBucketPrefix()) + String.format("%s/%s", DIRECT_PATH_PREFIX, prefix);
        S3Objects summaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.getConfiguredBucket(), (String)subpath);
        return StreamSupport.stream(summaries.spliterator(), false).map(S3ObjectSummary::getKey).filter(key -> key.endsWith(".properties")).map(this::attributePathToDirectPathBlobId);
    }

    private Stream<S3ObjectSummary> nonTempBlobPropertiesFileStream(Stream<S3ObjectSummary> summaries) {
        return summaries.filter(o -> o.getKey().endsWith(".properties")).filter(this::isNotTempBlob);
    }

    private boolean isNotTempBlob(S3ObjectSummary object) {
        try {
            ObjectMetadata objectMetadata = this.s3.getObjectMetadata(this.getConfiguredBucket(), object.getKey());
            Map userMetadata = objectMetadata.getUserMetadata();
            return !userMetadata.containsKey("BlobStore.temporary-blob");
        }
        catch (Exception e) {
            this.log.debug("An error occurred determining whether blob was temporary", (Throwable)e);
            return false;
        }
    }

    private Stream<BlobId> blobIdStream(Stream<S3ObjectSummary> summaries) {
        return this.nonTempBlobPropertiesFileStream(summaries).map(S3AttributesLocation::new).map(arg_0 -> ((S3BlobStore)this).getBlobIdFromAttributeFilePath(arg_0)).map(BlobId::new);
    }

    @Nullable
    @Timed
    public BlobAttributes getBlobAttributes(BlobId blobId) {
        try {
            S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), this.attributePath(blobId));
            return blobAttributes.load() ? blobAttributes : null;
        }
        catch (Exception e) {
            this.log.error("Unable to load S3BlobAttributes for blob id: {}", (Object)blobId, (Object)e);
            return null;
        }
    }

    @Timed
    public BlobAttributes getBlobAttributes(S3AttributesLocation attributesFilePath) throws IOException {
        S3BlobAttributes s3BlobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), attributesFilePath.getFullPath());
        s3BlobAttributes.load();
        return s3BlobAttributes;
    }

    @Timed
    public void setBlobAttributes(BlobId blobId, BlobAttributes blobAttributes) {
        try {
            S3BlobAttributes s3BlobAttributes = (S3BlobAttributes)this.getBlobAttributes(blobId);
            s3BlobAttributes.updateFrom(blobAttributes);
            s3BlobAttributes.store();
        }
        catch (Exception e) {
            this.log.error("Unable to set BlobAttributes for blob id: {}, exception: {}", new Object[]{blobId, e.getMessage(), this.log.isDebugEnabled() ? e : null});
        }
    }

    @Timed
    protected void doUndelete(BlobId blobId, BlobAttributes attributes) {
        this.s3.setObjectTagging(this.untagAsDeleted(this.contentPath(blobId)));
        this.s3.setObjectTagging(this.untagAsDeleted(this.attributePath(blobId)));
        this.storeMetrics.recordAddition(attributes.getMetrics().getContentSize());
    }

    @Timed
    public boolean isStorageAvailable() {
        try {
            return this.s3.doesBucketExistV2(this.getConfiguredBucket());
        }
        catch (SdkBaseException e) {
            this.log.warn("S3 bucket '{}' is not writable.", (Object)this.getConfiguredBucket(), (Object)e);
            return false;
        }
    }

    @Timed
    public boolean exists(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), this.attributePath(blobId));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Timer.Context existsContext = this.existsTimer.time();){
                return blobAttributes.load();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            this.log.debug("Unable to load attributes {} during existence check, exception", (Object)blobAttributes, (Object)ioe);
            return false;
        }
    }

    @Timed
    public Future<Boolean> asyncDelete(BlobId blobId) {
        if (this.preferAsyncCleanup) {
            return this.executorService.submit(() -> this.deleteHard(blobId));
        }
        return CompletableFuture.completedFuture(this.deleteHard(blobId));
    }

    @Timed
    public boolean deleteIfTemp(BlobId blobId) {
        S3Blob blob = (S3Blob)((Object)this.liveBlobs.getUnchecked((Object)blobId));
        if (blob != null) {
            Map headers = blob.getHeaders();
            if (headers == null || headers.containsKey("BlobStore.temporary-blob")) {
                return this.deleteHard(blobId);
            }
            this.log.debug("Not deleting. Blob with id: {} is permanent.", (Object)blobId.asUniqueString());
        }
        return false;
    }

    private BlobId attributePathToDirectPathBlobId(String s3Key) {
        Preconditions.checkArgument((boolean)s3Key.startsWith(String.valueOf(this.getBucketPrefix()) + DIRECT_PATH_PREFIX + "/"), (String)"Not direct path blob path: %s", (Object)s3Key);
        Preconditions.checkArgument((boolean)s3Key.endsWith(".properties"), (String)"Not blob attribute path: %s", (Object)s3Key);
        String blobName = s3Key.substring(0, s3Key.length() - ".properties".length()).substring((String.valueOf(this.getBucketPrefix()) + DIRECT_PATH_PREFIX).length() + 1);
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.blob-name", (Object)blobName, (Object)"BlobStore.direct-path", (Object)"true");
        return this.blobIdLocationResolver.fromHeaders((Map)headers);
    }

    public RawObjectAccess getRawObjectAccess() {
        return this.rawObjectAccess;
    }

    @VisibleForTesting
    public void flushMetrics() throws IOException {
        this.storeMetrics.flush();
    }

    private S3BlobAttributes writeBlobAttributes(Map<String, String> headers, String attributePath, BlobMetrics metrics) throws IOException {
        S3BlobAttributes blobAttributes = new S3BlobAttributes(this.s3, this.getConfiguredBucket(), attributePath, headers, metrics);
        blobAttributes.store();
        return blobAttributes;
    }

    private static interface BlobIngester {
        public StreamMetrics ingestTo(String var1) throws IOException;
    }

    class S3Blob
    extends BlobSupport {
        S3Blob(BlobId blobId) {
            super(blobId);
        }

        protected InputStream doGetInputStream() {
            S3Object object = S3BlobStore.this.s3.getObject(S3BlobStore.this.getConfiguredBucket(), S3BlobStore.this.contentPath(this.getId()));
            return S3BlobStore.this.performanceLogger.maybeWrapForPerformanceLogging((InputStream)object.getObjectContent());
        }
    }
}

