/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.thread.NexusThreadFactory;

public abstract class ParallelRequester
extends StateGuardLifecycleSupport {
    protected final int chunkSize;
    private final int parallelism;
    private final ExecutorService executorService;

    public ParallelRequester(int chunkSize, int numberOfThreads, String threadGroupName) {
        Preconditions.checkArgument((numberOfThreads >= 0 ? 1 : 0) != 0, (Object)"Must use a non-negative parallelism");
        Preconditions.checkArgument((chunkSize >= 0 ? 1 : 0) != 0, (Object)"Must use a non-negative chunkSize");
        this.chunkSize = chunkSize;
        this.parallelism = numberOfThreads > 0 ? numberOfThreads : Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newFixedThreadPool(this.parallelism, (ThreadFactory)new NexusThreadFactory("s3-parallel", threadGroupName));
    }

    protected void doStop() {
        this.executorService.shutdownNow();
    }

    protected void parallelRequests(AmazonS3 s3, String bucket, String key, Supplier<IOFunction<String, List<PartETag>>> operations) {
        InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(bucket, key);
        String uploadId = s3.initiateMultipartUpload(initiateRequest).getUploadId();
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.executorService);
        try {
            int i = 0;
            while (i < this.parallelism) {
                completionService.submit(() -> (List)((IOFunction)operations.get()).apply(uploadId));
                ++i;
            }
            ArrayList partETags = new ArrayList();
            int i2 = 0;
            while (i2 < this.parallelism) {
                partETags.addAll((Collection)completionService.take().get());
                ++i2;
            }
            s3.completeMultipartUpload(new CompleteMultipartUploadRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartETags(partETags));
        }
        catch (InterruptedException interruptedException) {
            s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
            Thread.currentThread().interrupt();
        }
        catch (CancellationException | ExecutionException ex) {
            s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
            throw new BlobStoreException(String.format("Error executing parallel requests for bucket:%s key:%s with uploadId:%s", bucket, key, uploadId), (Throwable)ex, null);
        }
    }

    @FunctionalInterface
    protected static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

