/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.ParallelRequester;
import org.sonatype.nexus.blobstore.s3.internal.S3Copier;

@Singleton
@Named(value="parallelCopier")
public class ParallelCopier
extends ParallelRequester
implements S3Copier {
    @Inject
    public ParallelCopier(@Named(value="${nexus.s3.parallelRequests.chunksize:-5242880}") int chunkSize, @Named(value="${nexus.s3.parallelRequests.parallelism:-0}") int nThreads) {
        super(chunkSize, nThreads, "copyThreads");
    }

    @Override
    @Timed
    public void copy(AmazonS3 s3, String bucket, String srcKey, String destKey) {
        long length = s3.getObjectMetadata(bucket, srcKey).getContentLength();
        try {
            if (length < (long)this.chunkSize) {
                s3.copyObject(bucket, srcKey, bucket, destKey);
            } else {
                AtomicInteger offset = new AtomicInteger(1);
                this.parallelRequests(s3, bucket, destKey, () -> uploadId -> this.copyParts(s3, (String)uploadId, bucket, srcKey, destKey, length, offset));
            }
        }
        catch (SdkClientException e) {
            throw new BlobStoreException("Error copying blob", (Throwable)e, null);
        }
    }

    private List<PartETag> copyParts(AmazonS3 s3, String uploadId, String bucket, String srcKey, String destKey, long size, AtomicInteger offset) {
        int partNumber;
        ArrayList<PartETag> tags = new ArrayList<PartETag>();
        while (ParallelCopier.getFirstByte(partNumber = offset.getAndIncrement(), this.chunkSize) < size) {
            CopyPartRequest request = new CopyPartRequest().withSourceBucketName(bucket).withSourceKey(srcKey).withDestinationBucketName(bucket).withDestinationKey(destKey).withUploadId(uploadId).withPartNumber(partNumber).withFirstByte(Long.valueOf(ParallelCopier.getFirstByte(partNumber, this.chunkSize))).withLastByte(Long.valueOf(ParallelCopier.getLastByte(size, partNumber, this.chunkSize)));
            tags.add(s3.copyPart(request).getPartETag());
        }
        return tags;
    }

    static long getFirstByte(long partNumber, long chunkSize) {
        return (partNumber - 1L) * chunkSize;
    }

    static long getLastByte(long size, long partNumber, long chunkSize) {
        return Math.min(partNumber * chunkSize, size) - 1L;
    }
}

