/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.S3Uploader;

@Named(value="multipart-uploader")
public class MultipartUploader
extends ComponentSupport
implements S3Uploader {
    private final int chunkSize;

    @Inject
    public MultipartUploader(@Named(value="${nexus.s3.multipartupload.chunksize:-5242880}") int chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public void upload(AmazonS3 s3, String bucket, String key, InputStream contents) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream input = contents;){
                InputStream chunkOne = this.readChunk(input);
                if (chunkOne.available() < this.chunkSize) {
                    this.uploadSinglePart(s3, bucket, key, chunkOne);
                } else {
                    this.uploadMultiPart(s3, bucket, key, chunkOne, contents);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SdkClientException | IOException e) {
            throw new BlobStoreException("Error uploading blob", e, null);
        }
    }

    private void uploadSinglePart(AmazonS3 s3, String bucket, String key, InputStream contents) throws IOException {
        this.log.debug("Starting upload to key {} in bucket {} of {} bytes", new Object[]{key, bucket, contents.available()});
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)contents.available());
        s3.putObject(bucket, key, contents, metadata);
    }

    private void uploadMultiPart(AmazonS3 s3, String bucket, String key, InputStream firstChunk, InputStream restOfContents) throws IOException {
        Preconditions.checkState((firstChunk.available() > 0 ? 1 : 0) != 0);
        String uploadId = null;
        try {
            InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(bucket, key);
            uploadId = s3.initiateMultipartUpload(initiateRequest).getUploadId();
            this.log.debug("Starting multipart upload {} to key {} in bucket {}", new Object[]{uploadId, key, bucket});
            ArrayList<UploadPartResult> results = new ArrayList<UploadPartResult>();
            int partNumber = 1;
            while (true) {
                InputStream chunk;
                InputStream inputStream = chunk = partNumber == 1 ? firstChunk : this.readChunk(restOfContents);
                if (chunk.available() == 0) break;
                this.log.debug("Uploading chunk {} for {} of {} bytes", new Object[]{partNumber, uploadId, chunk.available()});
                UploadPartRequest part = new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartNumber(partNumber).withInputStream(chunk).withPartSize((long)chunk.available());
                results.add(s3.uploadPart(part));
                ++partNumber;
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartETags(results);
            s3.completeMultipartUpload(compRequest);
            this.log.debug("Upload {} complete", (Object)uploadId);
            uploadId = null;
        }
        catch (Throwable throwable) {
            if (uploadId != null) {
                try {
                    s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
                }
                catch (Exception e) {
                    this.log.error("Error aborting S3 multipart upload to bucket {} with key {}", new Object[]{bucket, key, this.log.isDebugEnabled() ? e : null});
                }
            }
            throw throwable;
        }
        if (uploadId != null) {
            try {
                s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
            }
            catch (Exception e) {
                this.log.error("Error aborting S3 multipart upload to bucket {} with key {}", new Object[]{bucket, key, this.log.isDebugEnabled() ? e : null});
            }
        }
    }

    private InputStream readChunk(InputStream input) throws IOException {
        byte[] buffer = new byte[this.chunkSize];
        int offset = 0;
        int remain = this.chunkSize;
        int bytesRead = 0;
        while (remain > 0 && bytesRead >= 0) {
            bytesRead = input.read(buffer, offset, remain);
            if (bytesRead <= 0) continue;
            offset += bytesRead;
            remain -= bytesRead;
        }
        if (offset > 0) {
            return new ByteArrayInputStream(buffer, 0, offset);
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

