/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.NexusS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.text.Strings2;

@Named
public class AmazonS3Factory
extends ComponentSupport {
    public static final String DEFAULT = "DEFAULT";
    private final int defaultConnectionPoolSize;
    private final boolean cloudWatchMetricsEnabled;
    private final String cloudWatchMetricsNamespace;
    private final Time connectionTtl;

    @Inject
    public AmazonS3Factory(@Named(value="${nexus.s3.connection.pool:--1}") int connectionPoolSize, @Nullable @Named(value="${nexus.s3.connection.ttl:-null}") Time connectionTtl, @Named(value="${nexus.s3.cloudwatchmetrics.enabled:-false}") boolean cloudWatchMetricsEnabled, @Named(value="${nexus.s3.cloudwatchmetrics.namespace:-nexus-blobstore-s3}") String cloudWatchMetricsNamespace) {
        this.defaultConnectionPoolSize = connectionPoolSize;
        this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        this.cloudWatchMetricsNamespace = cloudWatchMetricsNamespace;
        this.connectionTtl = connectionTtl;
    }

    public AmazonS3 create(BlobStoreConfiguration blobStoreConfiguration) {
        NexusS3ClientBuilder builder = NexusS3ClientBuilder.standard();
        NestedAttributesMap s3Configuration = blobStoreConfiguration.attributes("s3");
        String accessKeyId = (String)s3Configuration.get("accessKeyId", String.class);
        String secretAccessKey = (String)s3Configuration.get("secretAccessKey", String.class);
        String region = (String)s3Configuration.get("region", String.class);
        String signerType = (String)s3Configuration.get("signertype", String.class);
        String forcePathStyle = (String)s3Configuration.get("forcepathstyle", String.class);
        int maximumConnectionPoolSize = Optional.ofNullable((String)s3Configuration.get("max_connection_pool_size", String.class)).filter((Predicate<String>)Predicates.not(Strings2::isBlank)).map(Integer::valueOf).orElse(-1);
        AWSCredentialsProvider credentialsProvider = null;
        if (!Strings.isNullOrEmpty((String)accessKeyId) && !Strings.isNullOrEmpty((String)secretAccessKey)) {
            String sessionToken = (String)s3Configuration.get("sessionToken", String.class);
            AWSCredentials credentials = this.buildCredentials(accessKeyId, secretAccessKey, sessionToken);
            String assumeRole = (String)s3Configuration.get("assumeRole", String.class);
            credentialsProvider = this.buildCredentialsProvider(credentials, region, assumeRole);
            builder = (NexusS3ClientBuilder)builder.withCredentials(credentialsProvider);
        }
        if (!this.isNullOrEmptyOrDefault(region)) {
            String endpoint = (String)s3Configuration.get("endpoint", String.class);
            builder = !Strings.isNullOrEmpty((String)endpoint) ? (NexusS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, region)) : (NexusS3ClientBuilder)builder.withRegion(region);
        }
        ClientConfiguration clientConfiguration = PredefinedClientConfigurations.defaultConfig();
        if (this.defaultConnectionPoolSize > 0 || maximumConnectionPoolSize > 0) {
            clientConfiguration.setMaxConnections(maximumConnectionPoolSize > 0 ? maximumConnectionPoolSize : this.defaultConnectionPoolSize);
        }
        if (!this.isNullOrEmptyOrDefault(signerType)) {
            clientConfiguration.setSignerOverride(signerType);
        }
        if (this.connectionTtl != null) {
            clientConfiguration.setConnectionTTL(this.connectionTtl.toMillis());
        }
        builder = (NexusS3ClientBuilder)builder.withClientConfiguration(clientConfiguration);
        builder = (NexusS3ClientBuilder)((Object)builder.withPathStyleAccessEnabled(Boolean.parseBoolean(forcePathStyle)));
        builder.withBlobStoreConfig(blobStoreConfiguration);
        if (this.cloudWatchMetricsEnabled) {
            if (credentialsProvider != null) {
                AwsSdkMetrics.setCredentialProvider((AWSCredentialsProvider)credentialsProvider);
            }
            AwsSdkMetrics.setMetricNameSpace((String)this.cloudWatchMetricsNamespace);
            if (!this.isNullOrEmptyOrDefault(region)) {
                AwsSdkMetrics.setRegion((String)region);
            }
            AwsSdkMetrics.enableDefaultMetrics();
            this.log.info("CloudWatch metrics enabled using namespace {}", (Object)this.cloudWatchMetricsNamespace);
        }
        return (AmazonS3)builder.build();
    }

    private AWSCredentials buildCredentials(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (Strings.isNullOrEmpty((String)sessionToken)) {
            return new BasicAWSCredentials(accessKeyId, secretAccessKey);
        }
        return new BasicSessionCredentials(accessKeyId, secretAccessKey, sessionToken);
    }

    private AWSCredentialsProvider buildCredentialsProvider(AWSCredentials credentials, String region, String assumeRole) {
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider(credentials);
        if (Strings.isNullOrEmpty((String)assumeRole)) {
            return credentialsProvider;
        }
        String stsRegion = Strings.isNullOrEmpty((String)region) ? this.defaultRegion() : region;
        AWSSecurityTokenService securityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).withCredentials((AWSCredentialsProvider)credentialsProvider)).build();
        return new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRole, "nexus-s3-session").withStsClient(securityTokenService).build();
    }

    private String defaultRegion() {
        try {
            return new DefaultAwsRegionProviderChain().getRegion();
        }
        catch (SdkClientException e) {
            String region = Regions.DEFAULT_REGION.getName();
            this.log.warn("Default AWS region not configured, using {}", (Object)region, (Object)e);
            return region;
        }
    }

    private boolean isNullOrEmptyOrDefault(String value) {
        return Strings.isNullOrEmpty((String)value) || DEFAULT.equals(value);
    }
}

