/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.BlobStoreConfigurationBuilder;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

public class S3BlobStoreConfigurationBuilder
extends BlobStoreConfigurationBuilder {
    private String bucket;
    private String region;
    private String expiration;
    private Optional<String> prefix = Optional.empty();
    private Optional<String> accessKey = Optional.empty();
    private Optional<String> accessSecret = Optional.empty();
    private Optional<String> assumeRole = Optional.empty();
    private Optional<String> sessionTokenKey = Optional.empty();
    private Optional<String> encryptionKey = Optional.empty();
    private Optional<String> encryptionType = Optional.empty();
    private Optional<String> endpoint = Optional.empty();
    private Optional<String> signerType = Optional.empty();
    private Optional<String> maxConnectionPool = Optional.empty();
    private Optional<Boolean> forcePathStyle = Optional.empty();

    private S3BlobStoreConfigurationBuilder(Supplier<BlobStoreConfiguration> configuration, String name) {
        super(name, configuration);
        super.type("S3");
    }

    public S3BlobStoreConfigurationBuilder bucket(String bucketName) {
        this.bucket = (String)Preconditions.checkNotNull((Object)bucketName, (Object)"Missing bucket name");
        return this;
    }

    public S3BlobStoreConfigurationBuilder region(String region) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Missing region");
        return this;
    }

    public S3BlobStoreConfigurationBuilder prefix(@Nullable String prefix) {
        this.prefix = Optional.ofNullable(prefix);
        return this;
    }

    public S3BlobStoreConfigurationBuilder expiration(String expiration) {
        return this.expiration(Integer.valueOf((String)Preconditions.checkNotNull((Object)expiration, (Object)"Missing expiration")));
    }

    public S3BlobStoreConfigurationBuilder expiration(Integer expiration) {
        this.expiration = ((Integer)Preconditions.checkNotNull((Object)expiration, (Object)"Missing expiration")).toString();
        return this;
    }

    public S3BlobStoreConfigurationBuilder accessKey(@Nullable String accessKey) {
        this.accessKey = Optional.ofNullable(accessKey);
        return this;
    }

    public S3BlobStoreConfigurationBuilder accessSecret(@Nullable String accessSecret) {
        this.accessSecret = Optional.ofNullable(accessSecret);
        return this;
    }

    public S3BlobStoreConfigurationBuilder assumeRole(@Nullable String assumeRole) {
        this.assumeRole = Optional.ofNullable(assumeRole);
        return this;
    }

    public S3BlobStoreConfigurationBuilder sessionTokenKey(@Nullable String sessionTokenKey) {
        this.sessionTokenKey = Optional.ofNullable(sessionTokenKey);
        return this;
    }

    public S3BlobStoreConfigurationBuilder encryptionKey(@Nullable String encryptionKey) {
        this.encryptionKey = Optional.ofNullable(encryptionKey);
        return this;
    }

    public S3BlobStoreConfigurationBuilder encryptionType(@Nullable String encryptionType) {
        this.encryptionType = Optional.ofNullable(encryptionType);
        return this;
    }

    public S3BlobStoreConfigurationBuilder endpoint(@Nullable String endpoint) {
        this.endpoint = Optional.ofNullable(endpoint);
        return this;
    }

    public S3BlobStoreConfigurationBuilder signerType(@Nullable String signerType) {
        this.signerType = Optional.ofNullable(signerType);
        return this;
    }

    public S3BlobStoreConfigurationBuilder maxConnectionPool(@Nullable String maxConnectionPool) {
        this.maxConnectionPool = Optional.ofNullable(maxConnectionPool);
        return this;
    }

    public S3BlobStoreConfigurationBuilder maxConnectionPool(@Nullable Integer maxConnectionPool) {
        this.maxConnectionPool = Optional.ofNullable(maxConnectionPool).map(String::valueOf);
        return this;
    }

    public S3BlobStoreConfigurationBuilder forcePathStyle(@Nullable Boolean forcePathStyle) {
        this.forcePathStyle = Optional.ofNullable(forcePathStyle);
        return this;
    }

    public S3BlobStoreConfigurationBuilder forcePathStyle(@Nullable String forcePathStyle) {
        this.forcePathStyle = forcePathStyle == null ? Optional.empty() : Optional.ofNullable(Boolean.valueOf(forcePathStyle));
        return this;
    }

    public BlobStoreConfigurationBuilder type(String type) {
        throw new IllegalStateException("The type cannot be changed.");
    }

    public BlobStoreConfiguration build() {
        BlobStoreConfiguration configuration = super.build();
        NestedAttributesMap s3 = configuration.attributes("s3");
        s3.set("bucket", Preconditions.checkNotNull((Object)this.bucket, (Object)"Missing bucket name"));
        s3.set("region", Preconditions.checkNotNull((Object)this.region, (Object)"Missing region"));
        s3.set("expiration", Preconditions.checkNotNull((Object)this.expiration, (Object)"Missing expiration"));
        this.prefix.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "prefix"));
        this.accessKey.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "accessKeyId"));
        this.accessSecret.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "secretAccessKey"));
        this.assumeRole.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "assumeRole"));
        this.sessionTokenKey.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "sessionToken"));
        this.encryptionKey.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "encryption_key"));
        this.encryptionType.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "encryption_type"));
        this.endpoint.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "endpoint"));
        this.signerType.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "signertype"));
        this.maxConnectionPool.ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "max_connection_pool_size"));
        this.forcePathStyle.filter(b -> b).map(String::valueOf).ifPresent(S3BlobStoreConfigurationBuilder.set(s3, "forcepathstyle"));
        return configuration;
    }

    private static Consumer<Object> set(NestedAttributesMap attributes, String key) {
        return value -> {
            Object object = attributes.set(key, value);
        };
    }

    public static S3BlobStoreConfigurationBuilder builder(BlobStoreConfiguration configuration, String name) {
        return new S3BlobStoreConfigurationBuilder(() -> configuration, name);
    }

    public static S3BlobStoreConfigurationBuilder builder(Supplier<BlobStoreConfiguration> configuration, String name) {
        return new S3BlobStoreConfigurationBuilder(configuration, name);
    }
}

