/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3ClientParamsWrapper;
import com.amazonaws.services.s3.EncryptingAmazonS3Client;
import com.amazonaws.services.s3.S3CredentialsProviderChain;
import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

public class NexusS3ClientBuilder
extends AmazonS3Builder<NexusS3ClientBuilder, AmazonS3> {
    private BlobStoreConfiguration blobStoreConfig;

    public static NexusS3ClientBuilder standard() {
        NexusS3ClientBuilder builder = new NexusS3ClientBuilder();
        builder.setCredentials((AWSCredentialsProvider)new S3CredentialsProviderChain());
        return builder;
    }

    public NexusS3ClientBuilder withBlobStoreConfig(BlobStoreConfiguration blobStoreConfig) {
        this.blobStoreConfig = (BlobStoreConfiguration)Preconditions.checkNotNull((Object)blobStoreConfig);
        return this;
    }

    public BlobStoreConfiguration getBlobStoreConfig() {
        return this.blobStoreConfig;
    }

    protected AmazonS3 build(AwsSyncClientParams clientParams) {
        Preconditions.checkNotNull((Object)this.getBlobStoreConfig());
        return new EncryptingAmazonS3Client(this.getBlobStoreConfig(), new AmazonS3ClientParamsWrapper(clientParams, this.resolveS3ClientOptions()));
    }
}

