/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitSetProducer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.support.NestedInnerQueryParseSupport;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.GeoDistanceSortParser;
import org.elasticsearch.search.sort.ScriptSortParser;
import org.elasticsearch.search.sort.SortParser;

public class SortParseElement
implements SearchParseElement {
    public static final SortField SORT_SCORE = new SortField(null, SortField.Type.SCORE);
    private static final SortField SORT_SCORE_REVERSE = new SortField(null, SortField.Type.SCORE, true);
    private static final SortField SORT_DOC = new SortField(null, SortField.Type.DOC);
    private static final SortField SORT_DOC_REVERSE = new SortField(null, SortField.Type.DOC, true);
    public static final ParseField IGNORE_UNMAPPED = new ParseField("ignore_unmapped", new String[0]).withAllDeprecated("unmapped_type");
    public static final ParseField UNMAPPED_TYPE = new ParseField("unmapped_type", new String[0]);
    private static final ParseField REVERSE_FIELD = new ParseField("reverse", new String[0]).withAllDeprecated("replaced by order");
    public static final String SCORE_FIELD_NAME = "_score";
    public static final String DOC_FIELD_NAME = "_doc";
    private final ImmutableMap<String, SortParser> parsers;

    public SortParseElement() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addParser((ImmutableMap.Builder<String, SortParser>)builder, new ScriptSortParser());
        this.addParser((ImmutableMap.Builder<String, SortParser>)builder, new GeoDistanceSortParser());
        this.parsers = builder.build();
    }

    private void addParser(ImmutableMap.Builder<String, SortParser> parsers, SortParser parser) {
        for (String name : parser.names()) {
            parsers.put((Object)name, (Object)parser);
        }
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SortField sortField;
        boolean sort;
        XContentParser.Token token = parser.currentToken();
        ArrayList<SortField> sortFields = new ArrayList<SortField>(2);
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    this.addCompoundSortField(parser, context, sortFields);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    this.addSortField(context, sortFields, parser.text(), false, null, null, null, null);
                    continue;
                }
                throw new IllegalArgumentException("malformed sort format, within the sort array, an object, or an actual string are allowed");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            this.addSortField(context, sortFields, parser.text(), false, null, null, null, null);
        } else if (token == XContentParser.Token.START_OBJECT) {
            this.addCompoundSortField(parser, context, sortFields);
        } else {
            throw new IllegalArgumentException("malformed sort format, either start with array, object, or an actual string");
        }
        if (!sortFields.isEmpty() && (sort = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != SortField.Type.SCORE || sortField.getReverse())) {
            context.sort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
        }
    }

    private void addCompoundSortField(XContentParser parser, SearchContext context, List<SortField> sortFields) throws Exception {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            boolean reverse = false;
            String missing = null;
            String innerJsonName = null;
            String unmappedType = null;
            MultiValueMode sortMode = null;
            NestedInnerQueryParseSupport nestedFilterParseHelper = null;
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                String direction = parser.text();
                if (direction.equals("asc")) {
                    reverse = SCORE_FIELD_NAME.equals(fieldName);
                } else if (direction.equals("desc")) {
                    reverse = !SCORE_FIELD_NAME.equals(fieldName);
                } else {
                    throw new IllegalArgumentException("sort direction [" + fieldName + "] not supported");
                }
                this.addSortField(context, sortFields, fieldName, reverse, unmappedType, missing, sortMode, nestedFilterParseHelper);
                continue;
            }
            if (this.parsers.containsKey((Object)fieldName)) {
                sortFields.add(((SortParser)this.parsers.get((Object)fieldName)).parse(parser, context));
                continue;
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    innerJsonName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (context.parseFieldMatcher().match(innerJsonName, REVERSE_FIELD)) {
                        reverse = parser.booleanValue();
                        continue;
                    }
                    if ("order".equals(innerJsonName)) {
                        if ("asc".equals(parser.text())) {
                            reverse = SCORE_FIELD_NAME.equals(fieldName);
                            continue;
                        }
                        if (!"desc".equals(parser.text())) continue;
                        reverse = !SCORE_FIELD_NAME.equals(fieldName);
                        continue;
                    }
                    if ("missing".equals(innerJsonName)) {
                        missing = parser.textOrNull();
                        continue;
                    }
                    if (context.parseFieldMatcher().match(innerJsonName, IGNORE_UNMAPPED)) {
                        if (unmappedType != null || !parser.booleanValue()) continue;
                        unmappedType = "long";
                        continue;
                    }
                    if (context.parseFieldMatcher().match(innerJsonName, UNMAPPED_TYPE)) {
                        unmappedType = parser.textOrNull();
                        continue;
                    }
                    if ("mode".equals(innerJsonName)) {
                        sortMode = MultiValueMode.fromString(parser.text());
                        continue;
                    }
                    if ("nested_path".equals(innerJsonName) || "nestedPath".equals(innerJsonName)) {
                        if (nestedFilterParseHelper == null) {
                            nestedFilterParseHelper = new NestedInnerQueryParseSupport(parser, context);
                        }
                        nestedFilterParseHelper.setPath(parser.text());
                        continue;
                    }
                    throw new IllegalArgumentException("sort option [" + innerJsonName + "] not supported");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if ("nested_filter".equals(innerJsonName) || "nestedFilter".equals(innerJsonName)) {
                    if (nestedFilterParseHelper == null) {
                        nestedFilterParseHelper = new NestedInnerQueryParseSupport(parser, context);
                    }
                    nestedFilterParseHelper.filter();
                    continue;
                }
                throw new IllegalArgumentException("sort option [" + innerJsonName + "] not supported");
            }
            this.addSortField(context, sortFields, fieldName, reverse, unmappedType, missing, sortMode, nestedFilterParseHelper);
        }
    }

    private void addSortField(SearchContext context, List<SortField> sortFields, String fieldName, boolean reverse, String unmappedType, @Nullable String missing, MultiValueMode sortMode, NestedInnerQueryParseSupport nestedHelper) throws IOException {
        if (SCORE_FIELD_NAME.equals(fieldName)) {
            if (reverse) {
                sortFields.add(SORT_SCORE_REVERSE);
            } else {
                sortFields.add(SORT_SCORE);
            }
        } else if (DOC_FIELD_NAME.equals(fieldName)) {
            if (reverse) {
                sortFields.add(SORT_DOC_REVERSE);
            } else {
                sortFields.add(SORT_DOC);
            }
        } else {
            IndexFieldData.XFieldComparatorSource.Nested nested;
            MappedFieldType fieldType = context.smartNameFieldType(fieldName);
            if (fieldType == null) {
                if (unmappedType != null) {
                    fieldType = context.mapperService().unmappedFieldType(unmappedType);
                } else {
                    throw new SearchParseException(context, "No mapping found for [" + fieldName + "] in order to sort on", null);
                }
            }
            if (!fieldType.isSortable()) {
                throw new SearchParseException(context, "Sorting not supported for field[" + fieldName + "]", null);
            }
            if (!(fieldType.isNumeric() || sortMode != MultiValueMode.SUM && sortMode != MultiValueMode.AVG)) {
                sortMode = null;
            }
            if (sortMode == null) {
                sortMode = SortParseElement.resolveDefaultSortMode(reverse);
            }
            if (nestedHelper != null && nestedHelper.getPath() != null) {
                BitSetProducer rootDocumentsFilter = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter());
                Query innerDocumentsFilter = nestedHelper.filterFound() ? nestedHelper.getInnerFilter() : nestedHelper.getNestedObjectMapper().nestedTypeFilter();
                nested = new IndexFieldData.XFieldComparatorSource.Nested(rootDocumentsFilter, context.searcher().createNormalizedWeight(innerDocumentsFilter, false));
            } else {
                nested = null;
            }
            IndexFieldData.XFieldComparatorSource fieldComparatorSource = context.fieldData().getForField(fieldType).comparatorSource(missing, sortMode, nested);
            sortFields.add(new SortField(fieldType.names().indexName(), fieldComparatorSource, reverse));
        }
    }

    private static MultiValueMode resolveDefaultSortMode(boolean reverse) {
        return reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
    }
}

