/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

class DocumentParser
implements Closeable {
    private CloseableThreadLocal<ParseContext.InternalParseContext> cache = new CloseableThreadLocal<ParseContext.InternalParseContext>(){

        @Override
        protected ParseContext.InternalParseContext initialValue() {
            return new ParseContext.InternalParseContext(DocumentParser.this.indexSettings, DocumentParser.this.docMapperParser, DocumentParser.this.docMapper, new ContentPath(0));
        }
    };
    private final Settings indexSettings;
    private final DocumentMapperParser docMapperParser;
    private final DocumentMapper docMapper;

    public DocumentParser(Settings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper) {
        this.indexSettings = indexSettings;
        this.docMapperParser = docMapperParser;
        this.docMapper = docMapper;
    }

    public ParsedDocument parseDocument(SourceToParse source) throws MapperParsingException {
        if (this.docMapper.type().equals("_default_")) {
            throw new IllegalArgumentException("It is forbidden to index into the default mapping [_default_]");
        }
        ParseContext.InternalParseContext context = this.cache.get();
        Mapping mapping = this.docMapper.mapping();
        if (source.type() != null && !source.type().equals(this.docMapper.type())) {
            throw new MapperParsingException("Type mismatch, provide type [" + source.type() + "] but mapper is of type [" + this.docMapper.type() + "]");
        }
        source.type(this.docMapper.type());
        XContentParser parser = source.parser();
        try {
            ObjectMapper objectMapper;
            if (parser == null) {
                parser = XContentHelper.createParser(source.source());
            }
            if (mapping.sourceTransforms.length > 0) {
                parser = DocumentParser.transform(mapping, parser);
            }
            context.reset(parser, new ParseContext.Document(), source);
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new MapperParsingException("Malformed content, must start with an object");
            }
            boolean emptyDoc = false;
            if (mapping.root.isEnabled()) {
                token = parser.nextToken();
                if (token == XContentParser.Token.END_OBJECT) {
                    emptyDoc = true;
                } else if (token != XContentParser.Token.FIELD_NAME) {
                    throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
                }
            }
            for (MetadataFieldMapper metadataMapper : mapping.metadataMappers) {
                metadataMapper.preParse(context);
            }
            if (!mapping.root.isEnabled()) {
                parser.skipChildren();
            } else if (!emptyDoc && (objectMapper = DocumentParser.parseObject((ParseContext)context, (ObjectMapper)mapping.root, true)) != null) {
                context.addDynamicMappingsUpdate(objectMapper);
            }
            for (MetadataFieldMapper metadataMapper : mapping.metadataMappers) {
                metadataMapper.postParse(context);
            }
            if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1) && source.parser() == null && parser != null && (token = parser.nextToken()) != null) {
                throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + (Object)((Object)token));
            }
        }
        catch (Throwable e) {
            if (e instanceof MapperParsingException) {
                throw (MapperParsingException)e;
            }
            if (source.source() != null && source.source().length() == 0) {
                throw new MapperParsingException("failed to parse, document is empty");
            }
            throw new MapperParsingException("failed to parse", e);
        }
        finally {
            if (source.parser() == null && parser != null) {
                parser.close();
            }
        }
        if (context.docs().size() > 1) {
            Collections.reverse(context.docs());
        }
        if (context.docBoost() != 1.0f) {
            HashSet encounteredFields = Sets.newHashSet();
            for (ParseContext.Document document : context.docs()) {
                encounteredFields.clear();
                for (IndexableField field : document) {
                    if (field.fieldType().indexOptions() == IndexOptions.NONE || field.fieldType().omitNorms() || encounteredFields.contains(field.name())) continue;
                    ((Field)field).setBoost(context.docBoost() * field.boost());
                    encounteredFields.add(field.name());
                }
            }
        }
        Mapper rootDynamicUpdate = context.dynamicMappingsUpdate();
        Mapping update = null;
        if (rootDynamicUpdate != null) {
            update = mapping.mappingUpdate(rootDynamicUpdate);
        }
        ParsedDocument parsedDocument = new ParsedDocument(context.uid(), context.version(), context.id(), context.type(), source.routing(), source.timestamp(), source.ttl(), context.docs(), context.source(), update).parent(source.parent());
        context.reset(null, null, null);
        return parsedDocument;
    }

    static ObjectMapper parseObject(ParseContext context, ObjectMapper mapper, boolean atRoot) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return null;
        }
        XContentParser parser = context.parser();
        String currentFieldName = parser.currentName();
        if (atRoot && MapperService.isMetadataField(currentFieldName) && Version.indexCreated(context.indexSettings()).onOrAfter(Version.V_2_0_0_beta1)) {
            throw new MapperParsingException("Field [" + currentFieldName + "] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
        }
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token.isValue()) {
            throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
        }
        ObjectMapper.Nested nested = mapper.nested();
        if (nested.isNested()) {
            ParseContext.Document nestedDoc = (context = context.createNestedContext(mapper.fullPath())).doc();
            ParseContext.Document parentDoc = nestedDoc.getParent();
            IndexableField uidField = parentDoc.getField("_uid");
            if (uidField != null) {
                nestedDoc.add(new Field("_uid", uidField.stringValue(), (FieldType)UidFieldMapper.Defaults.NESTED_FIELD_TYPE));
            }
            nestedDoc.add(new Field("_type", mapper.nestedTypePathAsString(), (FieldType)TypeFieldMapper.Defaults.FIELD_TYPE));
        }
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(mapper.pathType());
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        ObjectMapper update = null;
        while (token != XContentParser.Token.END_OBJECT) {
            ObjectMapper newUpdate = null;
            if (token == XContentParser.Token.START_OBJECT) {
                newUpdate = DocumentParser.parseObject(context, mapper, currentFieldName);
            } else if (token == XContentParser.Token.START_ARRAY) {
                newUpdate = DocumentParser.parseArray(context, mapper, currentFieldName);
            } else if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, currentFieldName);
            } else {
                if (token == null) {
                    throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but got EOF, has a concrete value been provided to it?");
                }
                if (token.isValue()) {
                    newUpdate = DocumentParser.parseValue(context, mapper, currentFieldName, token);
                }
            }
            token = parser.nextToken();
            if (newUpdate == null) continue;
            if (update == null) {
                update = newUpdate;
                continue;
            }
            update = update.merge(newUpdate, false);
        }
        context.path().pathType(origPathType);
        if (nested.isNested()) {
            ParseContext.Document nestedDoc = context.doc();
            ParseContext.Document parentDoc = nestedDoc.getParent();
            if (nested.isIncludeInParent()) {
                for (IndexableField field : nestedDoc.getFields()) {
                    if (field.name().equals("_uid") || field.name().equals("_type")) continue;
                    parentDoc.add(field);
                }
            }
            if (nested.isIncludeInRoot()) {
                ParseContext.Document rootDoc = context.rootDoc();
                if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                    for (IndexableField field : nestedDoc.getFields()) {
                        if (field.name().equals("_uid") || field.name().equals("_type")) continue;
                        rootDoc.add(field);
                    }
                }
            }
        }
        return update;
    }

    private static Mapper parseObjectOrField(ParseContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            return DocumentParser.parseObject(context, (ObjectMapper)mapper, false);
        }
        FieldMapper fieldMapper = (FieldMapper)mapper;
        Mapper update = fieldMapper.parse(context);
        if (fieldMapper.copyTo() != null) {
            DocumentParser.parseCopyFields(context, fieldMapper, fieldMapper.copyTo().copyToFields());
        }
        return update;
    }

    private static ObjectMapper parseObject(ParseContext context, ObjectMapper mapper, String currentFieldName) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + mapper.name() + "] trying to serialize an object with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        context.path().add(currentFieldName);
        ObjectMapper update = null;
        Mapper objectMapper = mapper.getMapper(currentFieldName);
        if (objectMapper != null) {
            Mapper subUpdate = DocumentParser.parseObjectOrField(context, objectMapper);
            if (subUpdate != null) {
                update = mapper.mappingUpdate(subUpdate);
            }
        } else {
            ObjectMapper.Dynamic dynamic = mapper.dynamic();
            if (dynamic == null) {
                dynamic = DocumentParser.dynamicOrDefault(context.root().dynamic());
            }
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(mapper.fullPath(), currentFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.TRUE) {
                context.path().remove();
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "object");
                if (builder == null) {
                    builder = ((ObjectMapper.Builder)MapperBuilders.object(currentFieldName).enabled(true)).pathType(mapper.pathType());
                    if (!(mapper instanceof RootObjectMapper) && mapper.dynamic() != ObjectMapper.Defaults.DYNAMIC) {
                        ((ObjectMapper.Builder)builder).dynamic(mapper.dynamic());
                    }
                }
                Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path());
                objectMapper = builder.build(builderContext);
                context.path().add(currentFieldName);
                update = mapper.mappingUpdate(DocumentParser.parseAndMergeUpdate(objectMapper, context));
            } else {
                context.parser().skipChildren();
            }
        }
        context.path().remove();
        return update;
    }

    private static ObjectMapper parseArray(ParseContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        String arrayFieldName = lastFieldName;
        Mapper mapper = parentMapper.getMapper(lastFieldName);
        if (mapper != null) {
            if (mapper instanceof ArrayValueMapperParser) {
                Mapper subUpdate = DocumentParser.parseObjectOrField(context, mapper);
                if (subUpdate != null) {
                    return parentMapper.mappingUpdate(subUpdate);
                }
                return null;
            }
            return DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
        }
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        if (dynamic == null) {
            dynamic = DocumentParser.dynamicOrDefault(context.root().dynamic());
        }
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), arrayFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.TRUE) {
            Mapper.Builder builder = context.root().findTemplateBuilder(context, arrayFieldName, "object");
            if (builder == null) {
                return DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
            }
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path());
            mapper = builder.build(builderContext);
            if (mapper != null && mapper instanceof ArrayValueMapperParser) {
                context.path().add(arrayFieldName);
                mapper = DocumentParser.parseAndMergeUpdate(mapper, context);
                return parentMapper.mappingUpdate(mapper);
            }
            return DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
        }
        return DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
    }

    private static ObjectMapper parseNonDynamicArray(ParseContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                return DocumentParser.parseObject(context, mapper, lastFieldName);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                return DocumentParser.parseArray(context, mapper, lastFieldName);
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                lastFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName);
                continue;
            }
            if (token == null) {
                throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
            }
            return DocumentParser.parseValue(context, mapper, lastFieldName, token);
        }
        return null;
    }

    private static ObjectMapper parseValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = parentMapper.getMapper(currentFieldName);
        if (mapper != null) {
            Mapper subUpdate = DocumentParser.parseObjectOrField(context, mapper);
            if (subUpdate == null) {
                return null;
            }
            return parentMapper.mappingUpdate(subUpdate);
        }
        return DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName, token);
    }

    private static void parseNullValue(ParseContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        Mapper mapper = parentMapper.getMapper(lastFieldName);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (parentMapper.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
        }
    }

    private static Mapper.Builder<?, ?> createBuilderFromFieldType(ParseContext context, MappedFieldType fieldType, String currentFieldName) {
        Mapper.Builder builder = null;
        if (fieldType instanceof StringFieldMapper.StringFieldType) {
            builder = context.root().findTemplateBuilder(context, currentFieldName, "string");
            if (builder == null) {
                builder = MapperBuilders.stringField(currentFieldName);
            }
        } else if (fieldType instanceof DateFieldMapper.DateFieldType) {
            builder = context.root().findTemplateBuilder(context, currentFieldName, "date");
            if (builder == null) {
                builder = MapperBuilders.dateField(currentFieldName);
            }
        } else {
            switch (fieldType.typeName()) {
                case "long": {
                    builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                    if (builder != null) break;
                    builder = MapperBuilders.longField(currentFieldName);
                    break;
                }
                case "double": {
                    builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                    if (builder != null) break;
                    builder = MapperBuilders.doubleField(currentFieldName);
                    break;
                }
                case "int": {
                    builder = context.root().findTemplateBuilder(context, currentFieldName, "integer");
                    if (builder != null) break;
                    builder = MapperBuilders.integerField(currentFieldName);
                    break;
                }
                case "float": {
                    builder = context.root().findTemplateBuilder(context, currentFieldName, "float");
                    if (builder != null) break;
                    builder = MapperBuilders.floatField(currentFieldName);
                    break;
                }
                case "boolean": {
                    builder = context.root().findTemplateBuilder(context, currentFieldName, "boolean");
                }
            }
        }
        if (builder == null) {
            Mapper.TypeParser.ParserContext parserContext = context.docMapperParser().parserContext(currentFieldName);
            Mapper.TypeParser typeParser = parserContext.typeParser(fieldType.typeName());
            if (typeParser == null) {
                throw new MapperParsingException("Cannot generate dynamic mappings of type [" + fieldType.typeName() + "] for [" + currentFieldName + "]");
            }
            builder = typeParser.parse(currentFieldName, new HashMap<String, Object>(), parserContext);
        }
        return builder;
    }

    private static Mapper.Builder<?, ?> createBuilderFromDynamicValue(ParseContext context, XContentParser.Token token, String currentFieldName) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            Mapper.Builder builder;
            String text;
            if (context.root().dateDetection() && (Strings.countOccurrencesOf(text = context.parser().text(), ":") > 1 || Strings.countOccurrencesOf(text, "-") > 1 || Strings.countOccurrencesOf(text, "/") > 1)) {
                for (FormatDateTimeFormatter dateTimeFormatter : context.root().dynamicDateTimeFormatters()) {
                    try {
                        dateTimeFormatter.parser().parseMillis(text);
                        Mapper.Builder builder2 = context.root().findTemplateBuilder(context, currentFieldName, "date");
                        if (builder2 == null) {
                            builder2 = MapperBuilders.dateField(currentFieldName).dateTimeFormatter(dateTimeFormatter);
                        }
                        return builder2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (context.root().numericDetection()) {
                text = context.parser().text();
                try {
                    Long.parseLong(text);
                    Mapper.Builder builder3 = context.root().findTemplateBuilder(context, currentFieldName, "long");
                    if (builder3 == null) {
                        builder3 = MapperBuilders.longField(currentFieldName);
                    }
                    return builder3;
                }
                catch (NumberFormatException builder3) {
                    try {
                        Double.parseDouble(text);
                        Mapper.Builder builder4 = context.root().findTemplateBuilder(context, currentFieldName, "double");
                        if (builder4 == null) {
                            builder4 = MapperBuilders.doubleField(currentFieldName);
                        }
                        return builder4;
                    }
                    catch (NumberFormatException builder4) {
                        // empty catch block
                    }
                }
            }
            if ((builder = context.root().findTemplateBuilder(context, currentFieldName, "string")) == null) {
                builder = MapperBuilders.stringField(currentFieldName);
            }
            return builder;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                if (builder == null) {
                    builder = MapperBuilders.longField(currentFieldName);
                }
                return builder;
            }
            if (numberType == XContentParser.NumberType.FLOAT || numberType == XContentParser.NumberType.DOUBLE) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                if (builder == null) {
                    builder = MapperBuilders.doubleField(currentFieldName);
                }
                return builder;
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "boolean");
                if (builder == null) {
                    builder = MapperBuilders.booleanField(currentFieldName);
                }
                return builder;
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "binary");
                if (builder == null) {
                    builder = MapperBuilders.binaryField(currentFieldName);
                }
                return builder;
            }
            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, null);
            if (builder != null) {
                return builder;
            }
        }
        throw new IllegalStateException("Can't handle serializing a dynamic type with content token [" + (Object)((Object)token) + "] and field name [" + currentFieldName + "]");
    }

    private static ObjectMapper parseDynamicValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        if (dynamic == null) {
            dynamic = DocumentParser.dynamicOrDefault(context.root().dynamic());
        }
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            return null;
        }
        String path = context.path().fullPathAsText(currentFieldName);
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path());
        MappedFieldType existingFieldType = context.mapperService().fullName(path);
        Mapper.Builder<?, ?> builder = null;
        if (existingFieldType != null) {
            builder = DocumentParser.createBuilderFromFieldType(context, existingFieldType, currentFieldName);
        }
        if (builder == null) {
            builder = DocumentParser.createBuilderFromDynamicValue(context, token, currentFieldName);
        }
        Object mapper = builder.build(builderContext);
        if (existingFieldType != null) {
            mapper = ((Mapper)mapper).updateFieldType(Collections.singletonMap(path, existingFieldType));
        }
        mapper = DocumentParser.parseAndMergeUpdate(mapper, context);
        ObjectMapper update = null;
        if (mapper != null) {
            update = parentMapper.mappingUpdate((Mapper)mapper);
        }
        return update;
    }

    private static void parseCopyFields(ParseContext context, FieldMapper fieldMapper, List<String> copyToFields) throws IOException {
        if (!context.isWithinCopyTo() && !copyToFields.isEmpty()) {
            context = context.createCopyToContext();
            for (String field : copyToFields) {
                ParseContext.Document targetDoc = null;
                for (ParseContext.Document doc = context.doc(); doc != null; doc = doc.getParent()) {
                    if (!field.startsWith(doc.getPrefix())) continue;
                    targetDoc = doc;
                    break;
                }
                assert (targetDoc != null);
                ParseContext copyToContext = targetDoc == context.doc() ? context : context.switchDoc(targetDoc);
                DocumentParser.parseCopy(field, copyToContext);
            }
        }
    }

    private static void parseCopy(String field, ParseContext context) throws IOException {
        FieldMapper fieldMapper = context.docMapper().mappers().getMapper(field);
        if (fieldMapper != null) {
            fieldMapper.parse(context);
        } else {
            int i;
            context = context.overridePath(new ContentPath(0));
            String[] paths = Strings.splitStringToArray(field, '.');
            String fieldName = paths[paths.length - 1];
            ObjectMapper mapper = context.root();
            ObjectMapper[] mappers = new ObjectMapper[paths.length - 1];
            if (paths.length > 1) {
                RootObjectMapper parent = context.root();
                for (i = 0; i < paths.length - 1; ++i) {
                    mapper = context.docMapper().objectMappers().get(context.path().fullPathAsText(paths[i]));
                    if (mapper == null) {
                        ObjectMapper.Dynamic dynamic = parent.dynamic();
                        if (dynamic == null) {
                            dynamic = DocumentParser.dynamicOrDefault(context.root().dynamic());
                        }
                        switch (dynamic) {
                            case STRICT: {
                                throw new StrictDynamicMappingException(parent.fullPath(), paths[i]);
                            }
                            case TRUE: {
                                Mapper.BuilderContext builderContext;
                                Mapper.Builder builder = context.root().findTemplateBuilder(context, paths[i], "object");
                                if (builder == null) {
                                    if (!(parent instanceof RootObjectMapper) && parent.dynamic() != ObjectMapper.Defaults.DYNAMIC) {
                                        ((ObjectMapper.Builder)builder).dynamic(parent.dynamic());
                                    }
                                    builder = ((ObjectMapper.Builder)MapperBuilders.object(paths[i]).enabled(true)).pathType(parent.pathType());
                                }
                                if ((mapper = (ObjectMapper)builder.build(builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path()))).nested() == ObjectMapper.Nested.NO) break;
                                throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + context.path().fullPathAsText(paths[i]) + "]) through `copy_to`");
                            }
                            case FALSE: {
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unexpected dynamic type " + (Object)((Object)dynamic)));
                            }
                        }
                    }
                    context.path().add(paths[i]);
                    mappers[i] = mapper;
                    parent = mapper;
                }
            }
            ObjectMapper update = DocumentParser.parseDynamicValue(context, mapper, fieldName, context.parser().currentToken());
            assert (update != null);
            if (paths.length > 1) {
                for (i = paths.length - 2; i >= 0; --i) {
                    ObjectMapper parent = context.root();
                    if (i > 0) {
                        parent = mappers[i - 1];
                    }
                    assert (parent != null);
                    update = ((ObjectMapper)parent).mappingUpdate(update);
                }
            }
            context.addDynamicMappingsUpdate(update);
        }
    }

    private static <M extends Mapper> M parseAndMergeUpdate(M mapper, ParseContext context) throws IOException {
        Mapper update = DocumentParser.parseObjectOrField(context, mapper);
        if (update != null) {
            mapper = mapper.merge(update, false);
        }
        return mapper;
    }

    private static XContentParser transform(Mapping mapping, XContentParser parser) throws IOException {
        Map<String, Object> transformed;
        try (XContentParser ignored = parser;){
            transformed = DocumentParser.transformSourceAsMap(mapping, parser.mapOrdered());
        }
        XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType()).value(transformed);
        return parser.contentType().xContent().createParser(builder.bytes());
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper.Dynamic dynamic) {
        return dynamic == null ? ObjectMapper.Dynamic.TRUE : dynamic;
    }

    static Map<String, Object> transformSourceAsMap(Mapping mapping, Map<String, Object> sourceAsMap) {
        if (mapping.sourceTransforms.length == 0) {
            return sourceAsMap;
        }
        for (Mapping.SourceTransform transform : mapping.sourceTransforms) {
            sourceAsMap = transform.transformSourceAsMap(sourceAsMap);
        }
        return sourceAsMap;
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

