/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;

public class FieldsVisitor
extends StoredFieldVisitor {
    private static final Set<String> BASE_REQUIRED_FIELDS = ImmutableSet.of((Object)"_uid", (Object)"_timestamp", (Object)"_ttl", (Object)"_routing", (Object)"_parent");
    private final boolean loadSource;
    private final Set<String> requiredFields;
    protected BytesReference source;
    protected Uid uid;
    protected Map<String, List<Object>> fieldsValues;

    public FieldsVisitor(boolean loadSource) {
        this.loadSource = loadSource;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.requiredFields.remove(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.requiredFields.isEmpty() ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    public void postProcess(MapperService mapperService) {
        DocumentMapper documentMapper;
        if (this.uid != null && (documentMapper = mapperService.documentMapper(this.uid.type())) != null) {
            this.postProcess(documentMapper);
            return;
        }
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = mapperService.indexName(entry.getKey());
            if (fieldType == null) continue;
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForSearch(fieldValues.get(i)));
            }
        }
    }

    public void postProcess(DocumentMapper documentMapper) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            String indexName = entry.getKey();
            FieldMapper fieldMapper = documentMapper.mappers().getMapper(indexName);
            if (fieldMapper == null) {
                for (FieldMapper mapper : documentMapper.mappers()) {
                    if (!mapper.fieldType().names().indexName().equals(indexName)) continue;
                    fieldMapper = mapper;
                    break;
                }
                if (fieldMapper == null) continue;
            }
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldMapper.fieldType().valueForSearch(fieldValues.get(i)));
            }
        }
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if ("_source".equals(fieldInfo.name)) {
            this.source = new BytesArray(value);
        } else {
            this.addValue(fieldInfo.name, new BytesRef(value));
        }
    }

    @Override
    public void stringField(FieldInfo fieldInfo, byte[] bytes) throws IOException {
        String value = new String(bytes, StandardCharsets.UTF_8);
        if ("_uid".equals(fieldInfo.name)) {
            this.uid = Uid.createUid(value);
        } else {
            this.addValue(fieldInfo.name, value);
        }
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.addValue(fieldInfo.name, value);
    }

    public BytesReference source() {
        return this.source;
    }

    public Uid uid() {
        return this.uid;
    }

    public String routing() {
        if (this.fieldsValues == null) {
            return null;
        }
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.get(0).toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues != null ? this.fieldsValues : ImmutableMap.of();
    }

    public void reset() {
        if (this.fieldsValues != null) {
            this.fieldsValues.clear();
        }
        this.source = null;
        this.uid = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add("_source");
        }
    }

    void addValue(String name, Object value) {
        List<Object> values;
        if (this.fieldsValues == null) {
            this.fieldsValues = Maps.newHashMap();
        }
        if ((values = this.fieldsValues.get(name)) == null) {
            values = new ArrayList<Object>(2);
            this.fieldsValues.put(name, values);
        }
        values.add(value);
    }
}

