/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.loader.SettingsLoader;

public class PropertiesSettingsLoader
implements SettingsLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> load(String source) throws IOException {
        HashMap hashMap;
        NoDuplicatesProperties props = new NoDuplicatesProperties();
        FastStringReader reader = new FastStringReader(source);
        try {
            props.load(reader);
            HashMap result = Maps.newHashMap();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(reader);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(reader);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> load(byte[] source) throws IOException {
        HashMap hashMap;
        NoDuplicatesProperties props = new NoDuplicatesProperties();
        StreamInput stream = StreamInput.wrap(source);
        try {
            props.load(stream);
            HashMap result = Maps.newHashMap();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(stream);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(stream);
        return hashMap;
    }

    class NoDuplicatesProperties
    extends Properties {
        NoDuplicatesProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object previousValue = super.put(key, value);
            if (previousValue != null) {
                throw new ElasticsearchParseException("duplicate settings key [{}] found, previous value [{}], current value [{}]", key, previousValue, value);
            }
            return previousValue;
        }
    }
}

