/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ossindex.internal.client;

import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyServerConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;
import org.sonatype.nexus.ossindex.internal.client.NexusUserAgentSupplier;
import org.sonatype.nexus.ossindex.internal.client.VulnerabilityClient;
import org.sonatype.nexus.ossindex.internal.client.VulnerabilityReport;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.internal.OssindexClientImpl;
import org.sonatype.ossindex.service.client.marshal.GsonMarshaller;
import org.sonatype.ossindex.service.client.marshal.Marshaller;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.HttpClientTransport;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class OssIndexVulnerabilityClient
extends LifecycleSupport
implements VulnerabilityClient,
EventAware {
    private OssindexClient ossindexClient;
    private final HttpClientManager httpClientManager;
    private final NexusIDService idService;

    @Inject
    public OssIndexVulnerabilityClient(HttpClientManager httpClientManager, NexusIDService idService) {
        this.httpClientManager = httpClientManager;
        this.idService = idService;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createClient();
    }

    private void createClient() {
        OssindexClientConfiguration config = new OssindexClientConfiguration();
        this.getProxyConfiguration().ifPresent(arg_0 -> ((OssindexClientConfiguration)config).setProxyConfiguration(arg_0));
        this.ossindexClient = new OssindexClientImpl(config, (Transport)new HttpClientTransport((UserAgentSupplier)new NexusUserAgentSupplier(this.idService.getNexusID())), (Marshaller)new GsonMarshaller());
    }

    private Optional<org.sonatype.ossindex.service.client.transport.ProxyConfiguration> getProxyConfiguration() {
        ProxyConfiguration proxy = this.httpClientManager.getConfiguration().getProxy();
        if (proxy != null && proxy.getHttp() != null) {
            return Optional.of(this.toProxyConfiguration(proxy.getHttp()));
        }
        return Optional.empty();
    }

    private org.sonatype.ossindex.service.client.transport.ProxyConfiguration toProxyConfiguration(ProxyServerConfiguration httpsProxy) {
        org.sonatype.ossindex.service.client.transport.ProxyConfiguration proxyConfiguration = new org.sonatype.ossindex.service.client.transport.ProxyConfiguration();
        proxyConfiguration.setHost(httpsProxy.getHost());
        proxyConfiguration.setPort(httpsProxy.getPort());
        AuthenticationConfiguration authentication = httpsProxy.getAuthentication();
        if (authentication != null) {
            if ("username".equals(authentication.getType())) {
                UsernameAuthenticationConfiguration basicAuth = (UsernameAuthenticationConfiguration)authentication;
                AuthConfiguration authConfiguration = new AuthConfiguration();
                authConfiguration.setUsername(basicAuth.getUsername());
                authConfiguration.setPassword(basicAuth.getPassword());
                proxyConfiguration.setAuthConfiguration(authConfiguration);
            } else {
                this.log.warn("HTTP proxy configuration type not supported for OSS Index service.");
            }
        }
        return proxyConfiguration;
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.closeClient();
    }

    private void closeClient() throws Exception {
        try {
            this.ossindexClient.close();
        }
        finally {
            this.ossindexClient = null;
        }
    }

    @Override
    public Map<PackageUrl, VulnerabilityReport> requestVulnerabilityReport(List<PackageUrl> coordinates) {
        try {
            return this.ossindexClient.requestComponentReports(coordinates).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VulnerabilityReport.toVulnerabilityReport((ComponentReport)e.getValue())));
        }
        catch (Exception e2) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Unable to obtain vulnerability report for {}", coordinates, (Object)e2);
            }
            return Collections.emptyMap();
        }
    }

    @Subscribe
    public void on(HttpClientConfigurationChangedEvent event) throws Exception {
        this.closeClient();
        this.createClient();
    }
}

