/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.p2.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.p2.internal.orient.OrientP2RestoreBlobData;
import com.sonatype.nexus.repository.p2.orient.P2RestoreFacet;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@Priority(value=0x7FFFFFFF)
@Named(value="p2")
@Singleton
public class OrientP2RestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<OrientP2RestoreBlobData> {
    @Inject
    public OrientP2RestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
    }

    protected OrientP2RestoreBlobData createRestoreData(RestoreBlobData restoreBlobData) {
        Preconditions.checkState((!StringUtils.isEmpty((String)restoreBlobData.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        return new OrientP2RestoreBlobData(restoreBlobData);
    }

    protected boolean canAttemptRestore(@Nonnull OrientP2RestoreBlobData p2RestoreBlobData) {
        Repository repository = this.getRepository(p2RestoreBlobData);
        Optional p2RestoreFacetFacet = repository.optionalFacet(P2RestoreFacet.class);
        if (!p2RestoreFacetFacet.isPresent()) {
            this.log.warn("Skipping as P2 Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull OrientP2RestoreBlobData p2RestoreBlobData) {
        return p2RestoreBlobData.getBlobData().getBlobName();
    }

    protected boolean assetExists(@Nonnull OrientP2RestoreBlobData p2RestoreBlobData) throws IOException {
        P2RestoreFacet facet = this.getRestoreFacet(p2RestoreBlobData);
        return facet.assetExists(this.getAssetPath(p2RestoreBlobData));
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return HashAlgorithm.ALL_HASH_ALGORITHMS.values().stream().collect(Collectors.toList());
    }

    protected boolean componentRequired(OrientP2RestoreBlobData data) {
        P2RestoreFacet facet = this.getRestoreFacet(data);
        String path = data.getBlobData().getBlobName();
        return facet.componentRequired(path);
    }

    protected Query getComponentQuery(OrientP2RestoreBlobData data) throws IOException {
        P2RestoreFacet facet = this.getRestoreFacet(data);
        RestoreBlobData blobData = data.getBlobData();
        return facet.getComponentQuery(blobData.getBlob(), blobData.getBlobName(), blobData.getBlobStore().getBlobStoreConfiguration().getName());
    }

    protected Repository getRepository(@Nonnull OrientP2RestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull OrientP2RestoreBlobData p2RestoreBlobData) throws IOException {
        P2RestoreFacet facet = this.getRestoreFacet(p2RestoreBlobData);
        String path = this.getAssetPath(p2RestoreBlobData);
        facet.restore(assetBlob, path);
    }

    private P2RestoreFacet getRestoreFacet(@Nonnull OrientP2RestoreBlobData p2RestoreBlobData) {
        Repository repository = this.getRepository(p2RestoreBlobData);
        return (P2RestoreFacet)repository.facet(P2RestoreFacet.class);
    }
}

