/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.i18n;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.i18n.MessageSource;
import org.sonatype.goodies.i18n.ResourceNotFoundException;

public class ResourceBundleMessageSource
extends ComponentSupport
implements MessageSource {
    private final List<ResourceBundle> bundles = Lists.newArrayList();
    private final Locale locale;

    public ResourceBundleMessageSource(Locale locale) {
        this.locale = (Locale)Preconditions.checkNotNull((Object)locale);
    }

    public ResourceBundleMessageSource(Class<?> ... types) {
        this(Locale.getDefault());
        this.add(types);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundleMessageSource add(boolean required, Class<?> ... types) {
        Preconditions.checkNotNull(types);
        for (Class<?> type : types) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(type.getName(), this.locale, type.getClassLoader());
                this.bundles.add(bundle);
            }
            catch (MissingResourceException e) {
                if (!required) continue;
                throw e;
            }
        }
        return this;
    }

    public ResourceBundleMessageSource add(Class<?> ... types) {
        return this.add(true, types);
    }

    @Override
    public String getMessage(String code) {
        Preconditions.checkNotNull((Object)code);
        for (ResourceBundle bundle : this.bundles) {
            try {
                return bundle.getString(code);
            }
            catch (MissingResourceException e) {
                this.log.trace(e.toString(), (Throwable)e);
            }
        }
        throw new ResourceNotFoundException(code);
    }

    @Override
    public String getMessage(String code, String defaultValue) {
        try {
            return this.getMessage(code);
        }
        catch (ResourceNotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    public String format(String code, Object ... args) {
        String pattern = this.getMessage(code);
        if (args != null) {
            return String.format(pattern, args);
        }
        return pattern;
    }
}

