/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.goodies.i18n.MessageSource;
import org.sonatype.goodies.i18n.ResourceBundleMessageSource;
import org.sonatype.goodies.i18n.ResourceNotFoundException;

public class I18N {
    private static final Logger log = LoggerFactory.getLogger(I18N.class);
    @VisibleForTesting
    static final String MISSING_MESSAGE_FORMAT = "ERROR_MISSING_MESSAGE[%s]";

    private I18N() {
    }

    public static MessageSource of(Class<?> ... types) {
        Preconditions.checkNotNull(types);
        Preconditions.checkArgument((types.length > 0 ? 1 : 0) != 0);
        return new ResourceBundleMessageSource(new Class[0]).add(false, types);
    }

    public static <T extends MessageBundle> T create(Class<T> type) {
        Preconditions.checkNotNull(type);
        return (T)((MessageBundle)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new Handler(type)));
    }

    private static class Handler
    implements InvocationHandler {
        private final Class<? extends MessageBundle> type;
        private final MessageSource messages;

        public Handler(Class<? extends MessageBundle> type) {
            this.type = (Class)Preconditions.checkNotNull(type);
            this.messages = I18N.of(type);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MessageBundle.DefaultMessage defaultMessage;
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (method.getReturnType() != String.class) {
                throw new Error("Illegal MessageBundle method: " + method);
            }
            String key = this.getKey(method);
            String format = this.getFormat(key);
            if (format == null && (defaultMessage = method.getAnnotation(MessageBundle.DefaultMessage.class)) != null) {
                format = defaultMessage.value();
            }
            if (format == null) {
                log.warn("Missing message for: {}, key: {}", this.type, (Object)key);
                return String.format(I18N.MISSING_MESSAGE_FORMAT, key);
            }
            if (args != null) {
                return String.format(format, args);
            }
            return format;
        }

        private String getFormat(String key) {
            try {
                return this.messages.getMessage(key);
            }
            catch (ResourceNotFoundException e) {
                log.trace("Missing resource for: {}, key: {}", this.type, (Object)key);
                return null;
            }
        }

        private String getKey(Method method) {
            MessageBundle.Key key = method.getAnnotation(MessageBundle.Key.class);
            if (key != null) {
                return key.value();
            }
            return method.getName();
        }
    }
}

