/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.AssetIdentificationService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.HealthCheckAssetDetailXO;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetVariableResolver;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientAssetIdentificationService
implements AssetIdentificationService {
    private final RepositoryManager repositoryManager;
    private final MavenPathParser mavenPathParser;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final Map<String, BiFunction<Asset, Component, ComponentIdentifier>> getterByFormat = new HashMap<String, BiFunction<Asset, Component, ComponentIdentifier>>();

    @Inject
    public OrientAssetIdentificationService(RepositoryManager repositoryManager, MavenPathParser mavenPathParser, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.initializeGetterByFormatMap();
    }

    private void initializeGetterByFormatMap() {
        this.getterByFormat.put("maven", this::getMavenComponentIdentifier);
        this.getterByFormat.put("nuget", this::getNugetComponentIdentifier);
        this.getterByFormat.put("npm", this::getNpmComponentIdentifier);
        this.getterByFormat.put("pypi", this::getPypiComponentIdentifier);
        this.getterByFormat.put("go", this::getGolangComponentIdentifier);
        this.getterByFormat.put("yum", this::getRpmComponentIdentifier);
        this.getterByFormat.put("rubygems", this::getRubygemsComponentIdentifier);
    }

    @Override
    public HealthCheckAssetDetailXO identify(String repositoryName, String assetName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (String)"Repository %s not found", (Object)repositoryName);
        Asset asset = (Asset)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return (Asset)Iterables.getFirst((Iterable)tx.findAssets(Query.builder().where("name").eq((Object)assetName).suffix("limit 1").build(), OrientAssetIdentificationService.allMembers(repository)), null);
        });
        Preconditions.checkArgument((asset != null ? 1 : 0) != 0, (String)"Asset %s not found in repository %s", (Object)assetName, (Object)repositoryName);
        this.ensurePermission(repository, asset);
        Component component = (Component)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return tx.findComponent(asset.componentId());
        });
        HealthCheckAssetDetailXO xo = new HealthCheckAssetDetailXO();
        xo.setHash(this.getHash(asset));
        xo.setComponentIdentifier(this.getComponentIdentifier(asset, component));
        return xo;
    }

    private static List<Repository> allMembers(Repository repository) {
        Optional optionalGroupFacet = repository.optionalFacet(GroupFacet.class);
        if (optionalGroupFacet.isPresent()) {
            return ((GroupFacet)optionalGroupFacet.get()).allMembers();
        }
        return Collections.singletonList(repository);
    }

    private void ensurePermission(Repository repository, Asset asset) {
        String format = repository.getFormat().getValue();
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(format);
        if (!this.contentPermissionChecker.isPermitted(repository.getName(), format, "read", assetVariableResolver.fromAsset(asset))) {
            throw new AuthorizationException();
        }
    }

    private String getHash(Asset asset) {
        HashCode hash = asset.getChecksum(HashAlgorithm.SHA1);
        Preconditions.checkState((hash != null ? 1 : 0) != 0, (String)"Asset %s has no SHA1", (Object)asset.name());
        return hash.toString();
    }

    public ComponentIdentifier getComponentIdentifier(Asset asset, Component component) {
        String format = this.getComponentFormat(asset.format());
        BiFunction<Asset, Component, ComponentIdentifier> getter = this.getterByFormat.get(format);
        if (getter == null) {
            throw new IllegalArgumentException("Unsupported format " + format);
        }
        return getter.apply(asset, component);
    }

    @Override
    public boolean isSupportedFormat(String format) {
        return this.getterByFormat.containsKey(this.getComponentFormat(format));
    }

    private ComponentIdentifier getGolangComponentIdentifier(Asset asset, Component component) {
        String name = component != null ? component.name() : null;
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name attribute for Go asset %s.", (Object)asset.name());
        String version = component != null ? component.version() : null;
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for Go asset %s.", (Object)asset.name());
        return ComponentIdentifier.createGolangCoordinates((String)name, (String)version);
    }

    private ComponentIdentifier getMavenComponentIdentifier(Asset asset, Component component) {
        String path = asset.name();
        MavenPath.Coordinates gav = this.mavenPathParser.parsePath(path).getCoordinates();
        Preconditions.checkArgument((gav != null ? 1 : 0) != 0, (String)"Malformed Maven component with path %s.", (Object)path);
        return ComponentIdentifier.createMavenCoordinates((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getVersion(), (String)Optional.ofNullable(gav.getClassifier()).orElse(""), (String)gav.getExtension());
    }

    private ComponentIdentifier getNugetComponentIdentifier(Asset asset, Component component) {
        String path = asset.name();
        String[] pathParts = path.split("/");
        Preconditions.checkArgument((pathParts.length == 2 ? 1 : 0) != 0, (String)"Malformed NuGet component with path %.", (Object)path);
        return ComponentIdentifier.createNugetCoordinates((String)pathParts[0], (String)pathParts[1]);
    }

    private ComponentIdentifier getNpmComponentIdentifier(Asset asset, Component component) {
        String path = asset.name();
        String[] pathParts = path.split("/");
        Preconditions.checkArgument(((pathParts.length == 4 || pathParts.length == 3) && path.endsWith(".tgz") ? 1 : 0) != 0, (String)"Malformed npm component with path %s. If this is packageRoot, try selecting the tarball instead.", (Object)path);
        String packageId = pathParts[0];
        int versionIdx = 2;
        int packageIdx = 0;
        if (pathParts.length == 4) {
            packageId = String.valueOf(packageId) + "/" + pathParts[1];
            ++versionIdx;
            ++packageIdx;
        }
        String version = pathParts[versionIdx].substring(pathParts[packageIdx].length() + 1, pathParts[versionIdx].indexOf(".tgz"));
        return ComponentIdentifier.createNpmCoordinates((String)packageId, (String)version);
    }

    private ComponentIdentifier getPypiComponentIdentifier(Asset asset, Component component) {
        String name = (String)asset.formatAttributes().get("name", String.class);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name attribute for PyPI asset %s.", (Object)asset.name());
        String version = (String)asset.formatAttributes().get("version", String.class);
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for PyPI asset %s.", (Object)asset.name());
        String path = asset.name();
        String filename = PyPiInfoUtils.parseFileName((String)path);
        String extension = PyPiInfoUtils.parseExtension((String)filename);
        String qualifier = PyPiInfoUtils.parseQualifier((String)filename, (String)version).orElse(null);
        return ComponentIdentifier.createPypiCoordinates((String)name, (String)version, (String)qualifier, (String)extension);
    }

    private ComponentIdentifier getRpmComponentIdentifier(Asset asset, Component component) {
        String name = (String)asset.formatAttributes().get("name", String.class);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name attribute for yum asset %s.", (Object)asset.name());
        String version = component != null ? component.version() : null;
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version for yum asset %s.", (Object)asset.name());
        String architecture = (String)asset.formatAttributes().get("architecture", String.class);
        Preconditions.checkArgument((architecture != null ? 1 : 0) != 0, (String)"Missing architecture attribute for yum asset %s.", (Object)asset.name());
        return ComponentIdentifier.createRpmCoordinates((String)name, (String)version, (String)architecture);
    }

    private ComponentIdentifier getRubygemsComponentIdentifier(Asset asset, Component component) {
        String name = component != null ? component.name() : null;
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name for RubyGem asset %s.", (Object)asset.name());
        String version = component != null ? component.version() : null;
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for RubyGem asset %s.", (Object)asset.name());
        String platform = (String)asset.formatAttributes().get("platform", String.class);
        Preconditions.checkArgument((platform != null ? 1 : 0) != 0, (String)"Missing platform attribute for RubyGem asset %s.", (Object)asset.name());
        return ComponentIdentifier.createRubyGemsCoordinates((String)name, (String)version, (String)platform);
    }

    private String getComponentFormat(String repositoryFormat) {
        if (repositoryFormat.startsWith("maven")) {
            return "maven";
        }
        return repositoryFormat;
    }
}

