/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.AssetIdentificationService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.HealthCheckAssetDetailXO;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackagePathParser;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.security.AssetVariableResolver;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

@Named
@Singleton
public class AssetIdentificationServiceImpl
implements AssetIdentificationService {
    private final RepositoryManager repositoryManager;
    private final MavenPathParser mavenPathParser;
    private final NugetPackagePathParser nugetPathParser;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final Map<String, BiFunction<FluentAsset, Component, ComponentIdentifier>> getterByFormat = new HashMap<String, BiFunction<FluentAsset, Component, ComponentIdentifier>>();

    @Inject
    public AssetIdentificationServiceImpl(RepositoryManager repositoryManager, MavenPathParser mavenPathParser, NugetPackagePathParser nugetPathParser, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
        this.nugetPathParser = (NugetPackagePathParser)Preconditions.checkNotNull((Object)nugetPathParser);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.initializeGetterByFormatMap();
    }

    private void initializeGetterByFormatMap() {
        this.getterByFormat.put("maven", this::getMavenComponentIdentifier);
        this.getterByFormat.put("nuget", this::getNugetComponentIdentifier);
        this.getterByFormat.put("pypi", this::getPypiComponentIdentifier);
        this.getterByFormat.put("npm", this::getNpmComponentIdentifier);
        this.getterByFormat.put("rubygems", this::getRubyGemsComponentIdentifier);
    }

    @Override
    public HealthCheckAssetDetailXO identify(String repositoryName, String assetName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (String)"Repository %s not found", (Object)repositoryName);
        FluentAsset asset = AssetIdentificationServiceImpl.allMembers(repository).stream().map(r -> ((ContentFacet)r.facet(ContentFacet.class)).assets().path(assetName).find().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        Preconditions.checkArgument((asset != null ? 1 : 0) != 0, (String)"Asset %s not found in repository %s", (Object)assetName, (Object)repositoryName);
        this.ensurePermission(repository, asset);
        Component component = asset.component().orElse(null);
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (String)"Component not found for asset %s in repository %s", (Object)assetName, (Object)repositoryName);
        HealthCheckAssetDetailXO xo = new HealthCheckAssetDetailXO();
        xo.setHash(this.getHash(asset));
        xo.setComponentIdentifier(this.getComponentIdentifier(asset, component));
        return xo;
    }

    @Override
    public boolean isSupportedFormat(String format) {
        return this.getterByFormat.containsKey(this.getComponentFormat(format));
    }

    private static List<Repository> allMembers(Repository repository) {
        Optional optionalGroupFacet = repository.optionalFacet(GroupFacet.class);
        if (optionalGroupFacet.isPresent()) {
            return ((GroupFacet)optionalGroupFacet.get()).allMembers();
        }
        return Collections.singletonList(repository);
    }

    private void ensurePermission(Repository repository, FluentAsset asset) {
        String format = repository.getFormat().getValue();
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(format);
        if (!this.contentPermissionChecker.isPermitted(repository.getName(), format, "read", assetVariableResolver.fromAsset(asset))) {
            throw new AuthorizationException();
        }
    }

    private String getHash(FluentAsset asset) {
        String hash = asset.blob().map(AssetBlob::checksums).map(c -> (String)c.get(HashAlgorithm.SHA1.name())).orElse(null);
        Preconditions.checkState((hash != null ? 1 : 0) != 0, (String)"Asset %s has no SHA1", (Object)asset.path());
        return hash;
    }

    public ComponentIdentifier getComponentIdentifier(FluentAsset asset, Component component) {
        String format = this.getComponentFormat(asset.repository().getFormat().getValue());
        BiFunction<FluentAsset, Component, ComponentIdentifier> getter = this.getterByFormat.get(format);
        if (getter == null) {
            throw new IllegalArgumentException("Unsupported format " + format);
        }
        return getter.apply(asset, component);
    }

    private ComponentIdentifier getMavenComponentIdentifier(FluentAsset asset, Component component) {
        String path = asset.path();
        MavenPath.Coordinates gav = this.mavenPathParser.parsePath(path).getCoordinates();
        Preconditions.checkArgument((gav != null ? 1 : 0) != 0, (String)"Malformed Maven component with path %s.", (Object)path);
        return ComponentIdentifier.createMavenCoordinates((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getVersion(), (String)Optional.ofNullable(gav.getClassifier()).orElse(""), (String)gav.getExtension());
    }

    private ComponentIdentifier getNugetComponentIdentifier(FluentAsset asset, Component component) {
        String path = asset.path();
        NugetPackageCoords coords = this.nugetPathParser.parsePath(path);
        Preconditions.checkArgument((coords != null ? 1 : 0) != 0, (String)"Malformed NuGet component with path %.", (Object)path);
        return ComponentIdentifier.createNugetCoordinates((String)coords.getId(), (String)coords.getVersion());
    }

    private ComponentIdentifier getNpmComponentIdentifier(FluentAsset asset, Component component) {
        String[] pathParts;
        String path;
        String pathWithoutLeadingSlash = path = asset.path();
        if (path.startsWith("/")) {
            pathWithoutLeadingSlash = path.substring(1);
        }
        Preconditions.checkArgument((((pathParts = pathWithoutLeadingSlash.split("/")).length == 4 || pathParts.length == 3) && pathWithoutLeadingSlash.endsWith(".tgz") ? 1 : 0) != 0, (String)"Malformed npm component with path %s. If this is packageRoot, try selecting the tarball instead.", (Object)path);
        String packageId = pathParts[0];
        int versionIdx = 2;
        int packageIdx = 0;
        if (pathParts.length == 4) {
            packageId = String.valueOf(packageId) + "/" + pathParts[1];
            ++versionIdx;
            ++packageIdx;
        }
        String version = pathParts[versionIdx].substring(pathParts[packageIdx].length() + 1, pathParts[versionIdx].indexOf(".tgz"));
        return ComponentIdentifier.createNpmCoordinates((String)packageId, (String)version);
    }

    private ComponentIdentifier getPypiComponentIdentifier(FluentAsset asset, Component component) {
        Map formatAttributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)asset);
        String name = (String)formatAttributes.get("name");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name attribute for PyPI asset %s.", (Object)name);
        String version = (String)formatAttributes.get("version");
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for PyPI asset %s.", (Object)name);
        String path = asset.path();
        String fileName = PyPiInfoUtils.parseFileName((String)path);
        String extension = PyPiInfoUtils.parseExtension((String)fileName);
        String qualifier = PyPiInfoUtils.parseQualifier((String)fileName, (String)version).orElse(null);
        return ComponentIdentifier.createPypiCoordinates((String)name, (String)version, (String)qualifier, (String)extension);
    }

    private ComponentIdentifier getRubyGemsComponentIdentifier(FluentAsset asset, Component component) {
        String name = component != null ? component.name() : null;
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name for RubyGem asset %s.", (Object)name);
        String version = component != null ? component.version() : null;
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for RubyGem asset %s.", (Object)name);
        Map formatAttributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)asset);
        String platform = (String)formatAttributes.get("platform");
        Preconditions.checkArgument((platform != null ? 1 : 0) != 0, (String)"Missing platform attribute for RubyGem asset %s.", (Object)name);
        return ComponentIdentifier.createRubyGemsCoordinates((String)name, (String)version, (String)platform);
    }

    private String getComponentFormat(String repositoryFormat) {
        if (repositoryFormat.startsWith("maven")) {
            return "maven";
        }
        return repositoryFormat;
    }
}

