/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal.ui;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.HealthCheckAssetDetailXO;

public interface AssetIdentificationService {
    public HealthCheckAssetDetailXO identify(String var1, String var2);

    public boolean isSupportedFormat(String var1);

    default public String getName(ComponentIdentifier componentIdentifier) {
        Preconditions.checkNotNull((Object)componentIdentifier);
        switch (componentIdentifier.getFormat()) {
            case "golang": {
                return componentIdentifier.get("name");
            }
            case "maven": {
                return componentIdentifier.get("artifactId");
            }
            case "npm": {
                return componentIdentifier.get("packageId");
            }
            case "nuget": {
                return componentIdentifier.get("packageId");
            }
            case "pypi": {
                return componentIdentifier.get("name");
            }
            case "rpm": {
                return componentIdentifier.get("name");
            }
            case "gem": {
                return componentIdentifier.get("name");
            }
        }
        return null;
    }

    default public String getGroup(ComponentIdentifier componentIdentifier) {
        Preconditions.checkNotNull((Object)componentIdentifier);
        switch (componentIdentifier.getFormat()) {
            case "maven": {
                return componentIdentifier.get("groupId");
            }
            case "npm": {
                String[] identifiers = componentIdentifier.get("packageId").split("\\/");
                return identifiers.length == 2 ? identifiers[0] : null;
            }
        }
        return null;
    }
}

