/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.clm.internal.identification.orient;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.clm.internal.identification.ClmSearchService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.orient.OrientAssetIdentificationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.ElasticSearchUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientClmSearchService
extends ComponentSupport
implements ClmSearchService {
    private static final int TRUNCATED_SHA1_LENGTH = 20;
    private static final int SHA1_LENGTH = 40;
    private static final int SHA256_LENGTH = 64;
    private static final int SHA512_LENGTH = 128;
    private final OrientAssetIdentificationService assetIdentificationService;
    private final ElasticSearchUtils elasticSearchUtils;
    private final ElasticSearchQueryService elasticSearchQueryService;

    @Inject
    public OrientClmSearchService(ElasticSearchUtils elasticSearchUtils, ElasticSearchQueryService elasticSearchQueryService, OrientAssetIdentificationService assetIdentificationService) {
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
        this.elasticSearchUtils = (ElasticSearchUtils)Preconditions.checkNotNull((Object)elasticSearchUtils);
        this.assetIdentificationService = (OrientAssetIdentificationService)Preconditions.checkNotNull((Object)assetIdentificationService);
    }

    @Override
    public List<ComponentDetails> identify(List<String> hashes) {
        Iterable searchHits = this.elasticSearchQueryService.browse(this.createQuery(hashes));
        HashMap hashToCandidates = new HashMap();
        Function<Map<String, Object>, String> hashExtractor = this.hashExtractor(hashes.get(0));
        StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.extractAssets((SearchHit)hit, hashes, hashExtractor)).forEach(candidate -> {
            boolean bl = hashToCandidates.computeIfAbsent(candidate.getHash(), h -> new ArrayList()).add(candidate);
        });
        return hashToCandidates.values().stream().map(candidates -> candidates.stream().min(Comparator.comparing(ComponentDetails::getCatalogDate)).get()).collect(Collectors.toList());
    }

    @Override
    public List<ComponentDetails> getVersions(ComponentIdentifier identifier, @Nullable String hash) {
        if (this.assetIdentificationService.isSupportedFormat(identifier.getFormat())) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must((QueryBuilder)QueryBuilders.termQuery((String)"name.raw", (String)this.assetIdentificationService.getName(identifier)));
            String group = this.assetIdentificationService.getGroup(identifier);
            if (group != null) {
                query.must((QueryBuilder)QueryBuilders.termQuery((String)"group", (String)group));
            }
            Iterable searchHits = this.elasticSearchQueryService.browse((QueryBuilder)query);
            Function<Map<String, Object>, String> hashExtractor = this.hashExtractor(hash);
            Equivalence wrapper = Equivalence.equals().onResultOf(ComponentDetails::getVersion);
            return StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.extractComponentDetails((SearchHit)hit, hashExtractor)).filter(OrientClmSearchService.versionlessMatch(identifier)).map(arg_0 -> ((Equivalence)wrapper).wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).collect(Collectors.toList());
        }
        throw new WebApplicationException("Unsupported format: " + identifier.getFormat(), Response.Status.BAD_REQUEST);
    }

    private Stream<ComponentDetails> extractAssets(SearchHit componentHit, List<String> hashes, Function<Map<String, Object>, String> hashExtractor) {
        Map componentMap = (Map)Preconditions.checkNotNull((Object)componentHit.getSource());
        Repository repository = this.elasticSearchUtils.getRepository((String)componentMap.get("repository_name"));
        List assets = (List)componentMap.get("assets");
        if (assets == null) {
            return Stream.empty();
        }
        ArrayList<ComponentDetails> matches = new ArrayList<ComponentDetails>();
        for (Map asset : assets) {
            String assetHash = hashExtractor.apply(asset);
            Optional<String> originalHash = hashes.stream().filter(assetHash::startsWith).findAny();
            if (!originalHash.isPresent()) continue;
            matches.add(this.createComponentDetails(repository, originalHash.get(), asset));
        }
        return matches.stream();
    }

    private Stream<ComponentDetails> extractComponentDetails(SearchHit componentHit, Function<Map<String, Object>, String> hashExtractor) {
        Map componentMap = (Map)Preconditions.checkNotNull((Object)componentHit.getSource());
        Repository repository = this.elasticSearchUtils.getRepository((String)componentMap.get("repository_name"));
        List assets = (List)componentMap.get("assets");
        if (assets == null) {
            return Stream.empty();
        }
        return assets.stream().map(asset -> this.createComponentDetails(repository, (String)hashExtractor.apply((Map<String, Object>)asset), (Map<String, Object>)asset)).filter((Predicate<ComponentDetails>)Predicates.notNull());
    }

    private ComponentDetails createComponentDetails(Repository repository, String assetHash, Map<String, Object> assetMap) {
        Component component;
        Asset asset;
        Throwable throwable = null;
        Object var7_6 = null;
        try (StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            asset = tx.findAssetWithProperty("name", assetMap.get("name"));
            component = tx.findComponent(asset.componentId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!this.assetIdentificationService.isSupportedFormat(asset.format())) {
            return null;
        }
        ComponentIdentifier identifier = this.assetIdentificationService.getComponentIdentifier(asset, component);
        ComponentDetails details = new ComponentDetails();
        details.setCatalogDate(Long.valueOf(asset.blobUpdated().getMillis()));
        details.setHash(assetHash);
        details.setIdentificationSourceComment(repository.getName());
        details.setComponentIdentifier(identifier);
        details.setMatchState("exact");
        details.setComponentCategories(Collections.emptyList());
        return details;
    }

    private QueryBuilder createQuery(List<String> hashes) {
        String sampleHash = hashes.get(0);
        String hashType = this.getHashType(sampleHash);
        if (sampleHash.length() == 20) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            hashes.stream().map(hash -> QueryBuilders.wildcardQuery((String)"assets.attributes.checksum.sha1", (String)(String.valueOf(hash) + "*"))).forEach(arg_0 -> ((BoolQueryBuilder)query).should(arg_0));
            return query;
        }
        return QueryBuilders.termsQuery((String)("assets.attributes.checksum." + hashType), hashes);
    }

    private Function<Map<String, Object>, String> hashExtractor(String sampleHash) {
        String hashType = this.getHashType(sampleHash);
        Function<Map<String, Object>, String> extractor = assetMap -> Optional.ofNullable((Map)assetMap.get("attributes")).map(attr -> (Map)attr.get("checksum")).map(checksums -> checksums.get(hashType)).map(String.class::cast).orElse(null);
        if (sampleHash == null || sampleHash.length() == 20) {
            return assetMap -> {
                String hash = (String)extractor.apply((Map<String, Object>)assetMap);
                return hash == null ? null : hash.substring(0, 20);
            };
        }
        return extractor;
    }

    @NotNull
    private String getHashType(String sampleHash) {
        int hashLength = sampleHash == null ? 20 : sampleHash.length();
        switch (hashLength) {
            case 0: 
            case 20: 
            case 40: {
                return "sha1";
            }
            case 64: {
                return "sha256";
            }
            case 128: {
                return "sha512";
            }
        }
        this.log.error("Unknown hash type for {}", (Object)sampleHash);
        throw new WebApplicationException("Unsupported hash type for " + sampleHash, Response.Status.BAD_REQUEST);
    }

    private static Predicate<ComponentDetails> versionlessMatch(ComponentIdentifier original) {
        List keys = original.getCoordinates().keySet().stream().filter(Predicates.not("version"::equals)).collect(Collectors.toList());
        return component -> {
            ComponentIdentifier identifier = component.getComponentIdentifier();
            if (!identifier.getFormat().equals(original.getFormat())) {
                return false;
            }
            if (identifier.getCoordinates().size() != original.getCoordinates().size()) {
                return false;
            }
            return keys.stream().allMatch(key -> Objects.equal((Object)original.get(key), (Object)identifier.get(key)));
        };
    }
}

