/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.clm.internal.identification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.component.InvalidComponentIdentifierException;
import com.sonatype.nexus.plugins.clm.internal.identification.ClmSearchService;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.AssetIdentificationService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;

@Path(value="internal/clm/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Named
@Singleton
public class ClmIdentificationResource
extends ComponentSupport
implements Resource {
    private static final Predicate<String> isNotHexadecimal = Pattern.compile("[a-f0-9]+").asPredicate().negate();
    static final String RESOURCE_URI = "internal/clm/";
    private final ObjectReader reader = new ObjectMapper().readerFor(ComponentIdentifier.class);
    private final ClmSearchService clmSearchService;
    private final AssetIdentificationService assetIdentificationService;

    @Inject
    public ClmIdentificationResource(ClmSearchService clmSearchService, AssetIdentificationService assetIdentificationService) {
        this.clmSearchService = (ClmSearchService)Preconditions.checkNotNull((Object)clmSearchService);
        this.assetIdentificationService = (AssetIdentificationService)Preconditions.checkNotNull((Object)assetIdentificationService);
    }

    private void validate(List<String> hashes) {
        if (hashes.stream().anyMatch(isNotHexadecimal)) {
            this.log.warn("Request for identification of non-hexidecimal hash: {}", hashes);
            throw new WebApplicationException("Request for identification of non-hexidecimal hash", Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="identification")
    @POST
    @RequiresAuthentication
    public List<ComponentDetails> identify(@NotEmpty List<String> hashes) {
        if (hashes.isEmpty()) {
            return Collections.emptyList();
        }
        this.validate(hashes);
        return this.clmSearchService.identify(hashes);
    }

    @Path(value="versions")
    @GET
    @RequiresAuthentication
    public List<ComponentDetails> getVersions(@NotNull @QueryParam(value="identifier") String identifierString, @QueryParam(value="hash") String hash) {
        ComponentIdentifier identifier = this.readIdentifier(identifierString);
        if (this.assetIdentificationService.isSupportedFormat(identifier.getFormat())) {
            return this.clmSearchService.getVersions(identifier, hash);
        }
        throw new WebApplicationException("Unsupported format: " + identifier.getFormat(), Response.Status.BAD_REQUEST);
    }

    private ComponentIdentifier readIdentifier(String identifierString) {
        ComponentIdentifier identifier = null;
        try {
            identifier = (ComponentIdentifier)this.reader.readValue(identifierString);
            identifier.validate();
            return identifier;
        }
        catch (IOException e) {
            this.log.error("An error occurred deserializing ComponentIdentifier {}", (Object)identifierString, (Object)e);
            throw new WebApplicationException("An error occurred deserializing the ComponentIdentifier", Response.Status.BAD_REQUEST);
        }
        catch (InvalidComponentIdentifierException e) {
            this.log.error("Request with an invalid ComponentIdentifier {}", (Object)identifier, (Object)e);
            throw new WebApplicationException("The provided ComponentIdentifier is invalid. " + e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }
}

