/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.time.Duration;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class DockerUploadPurgeTask
extends TaskSupport
implements Cancelable {
    public static final String AGE_FIELD_ID = "age";
    private final RepositoryManager repositoryManager;

    @Inject
    public DockerUploadPurgeTask(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public Void execute() throws Exception {
        int ageHours = this.getConfiguration().getInteger(AGE_FIELD_ID, -1);
        Preconditions.checkArgument((ageHours >= 0 ? 1 : 0) != 0, (String)"Age in hours cannot be negative, found: %s.", (int)ageHours);
        Streams.stream((Iterable)this.repositoryManager.browse()).map(repository -> repository.optionalFacet(DockerHostedFacet.class)).filter(Optional::isPresent).map(Optional::get).forEach(dockerHostedFacet -> dockerHostedFacet.purgeUploads(Duration.ofHours(ageHours)));
        return null;
    }

    public String getMessage() {
        return "Delete incomplete docker uploads";
    }
}

