/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;

@Named(value="datastore_search_attributes.docker.layerAncestry")
@Singleton
public class DockerLayerIdSqlSearchQueryContribution
extends SqlSearchQueryContributionSupport {
    public static final String NAME = "datastore_search_attributes.docker.layerAncestry";

    @Inject
    public DockerLayerIdSqlSearchQueryContribution(SqlSearchQueryConditionBuilder sqlSearchQueryConditionBuilder, Map<String, SearchMappings> searchMappings) {
        super(sqlSearchQueryConditionBuilder, searchMappings);
    }

    public void contribute(SqlSearchQueryBuilder queryBuilder, SearchFilter searchFilter) {
        Optional.ofNullable(searchFilter).flatMap(arg_0 -> ((DockerLayerIdSqlSearchQueryContribution)this).buildQueryCondition(arg_0)).ifPresent(arg_0 -> ((SqlSearchQueryBuilder)queryBuilder).add(arg_0));
    }

    private String getPrefixedSearchFilter(String value) {
        return this.startsWith(value);
    }

    private String startsWith(String value) {
        return StringUtils.prependIfMissing((String)value, (CharSequence)"*", (CharSequence[])new CharSequence[0]);
    }

    protected Set<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new HashSet<String>();
        }
        Matcher matcher = this.getMatcher(value);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(this.getPrefixedSearchFilter(DockerLayerIdSqlSearchQueryContribution.maybeTrimQuotes((String)matcher.group())));
        }
        return new HashSet<String>(matches);
    }
}

