/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.MediaType;
import org.sonatype.nexus.repository.docker.internal.V2ContentTypes;
import org.sonatype.nexus.repository.docker.internal.V2Error;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfig;
import org.sonatype.nexus.repository.docker.internal.V2ManifestConfigDowngrader;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema1;
import org.sonatype.nexus.repository.docker.internal.V2ManifestSchema2;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.orient.DockerAssetSearch;
import org.sonatype.nexus.repository.docker.internal.orient.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.http.HttpStatus;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.ContentTypes;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class V2ManifestUtilImpl
extends ComponentSupport
implements V2ManifestUtil,
GroovyObject {
    private static final byte[] EMPTY_BLOB_BYTES;
    private static final String SIGNATURE_BLOCK = "(?s),\\s*\"signatures\".*]";
    private static final ObjectMapper MAPPER;
    @Inject
    private V2ManifestConfigDowngrader v2ManifestConfigDowngrader;
    @Inject
    private DockerAssetSearch dockerAssetSearch;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public V2ManifestUtilImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        byte[] byArray = (byte[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{31, 139, 8, 0, 0, 9, 110, 136, 0, 255, 98, 24, 5, 163, 96, 20, 140, 88, 0, 8, 0, 0, 255, 255, 46, 175, 181, 239, 0, 4, 0, 0}), byte[].class);
        EMPTY_BLOB_BYTES = byArray;
        Object object = V2ManifestUtilImpl.$getCallSiteArray()[0].callConstructor(ObjectMapper.class);
        MAPPER = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        V2ManifestUtilImpl.$getCallSiteArray()[1].call((Object)MAPPER, V2ManifestUtilImpl.$getCallSiteArray()[2].callGetProperty(SerializationFeature.class));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V2Manifest readManifest(InputStreamSupplier manifestContent, String name, @Nullable String contentType) throws IOException {
        block11: {
            block9: {
                block10: {
                    var4_4 = V2ManifestUtilImpl.$getCallSiteArray();
                    var4_4[3].callStatic(Preconditions.class, (Object)manifestContent);
                    var4_4[4].callStatic(Preconditions.class, (Object)name);
                    var5_5 = contentType;
                    var4_4[5].call(var4_4[6].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} of type {}", (Object)name, (Object)(DefaultTypeTransformation.booleanUnbox((Object)var5_5) != false ? var5_5 : "unspecified"));
                    manifest = (Map)ScriptBytecodeAdapter.castToType((Object)var4_4[7].call(var4_4[8].call((Object)manifestContent), (Object)new _readManifest_closure1(this, this)), Map.class);
                    schemaVersion = var4_4[9].call((Object)manifest, (Object)"schemaVersion");
                    v2Manifest = null;
                    if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[10].callGetProperty(V2Manifest.class), (Object)schemaVersion)) break block10;
                    if (DefaultTypeTransformation.booleanUnbox((Object)var4_4[11].call((Object)manifest, (Object)"signatures"))) {
                        var9_9 = var4_4[12].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[13].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[14].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var9_9, V2Manifest.class);
                    } else {
                        var10_10 = var4_4[15].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[16].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", var4_4[17].callGetProperty(V2ContentTypes.class), "manifest", manifest}));
                        v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var10_10, V2Manifest.class);
                    }
                    ** GOTO lbl48
                }
                if (!ScriptBytecodeAdapter.compareEqual((Object)var4_4[18].callGetProperty(V2Manifest.class), (Object)schemaVersion)) ** GOTO lbl47
                if (!(DefaultTypeTransformation.booleanUnbox((Object)var4_4[19].call((Object)manifest, (Object)"mediaType")) != false && DefaultTypeTransformation.booleanUnbox((Object)var4_4[20].call(var4_4[21].callGetProperty(MediaType.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)var4_4[22].call((Object)manifest, (Object)"mediaType"), String.class)), String.class))) != false)) break block9;
                mediaType = ShortTypeHandling.castToString((Object)var4_4[23].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[24].callGetProperty(MediaType.class)));
                var12_12 = var4_4[25].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[26].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest, "layers", ScriptBytecodeAdapter.createList((Object[])new Object[0])}));
                v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var12_12, V2Manifest.class);
                var13_13 = v2Manifest;
                return var13_13;
            }
            mediaType = ShortTypeHandling.castToString((Object)var4_4[27].callCurrent((GroovyObject)this, (Object)contentType, (Object)manifest, var4_4[28].callGetProperty(MediaType.class)));
            var15_15 = var4_4[29].callConstructor(V2Manifest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"schemaVersion", var4_4[30].callGetProperty(V2Manifest.SchemaVersion.class), "mediaType", mediaType, "manifest", manifest}));
            v2Manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)var15_15, V2Manifest.class);
            break block11;
lbl47:
            // 1 sources

            throw (Throwable)var4_4[31].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, schemaVersion}, new String[]{"Invalid manifest ", ": unknown 'schemaVersion' ", ""}));
        }
        var16_16 = var4_4[32].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[33].call((Object)V2ManifestUtilImpl.MAPPER, var4_4[34].call((Object)manifest, (Object)(ScriptBytecodeAdapter.compareEqual((Object)var4_4[35].callGetProperty(V2Manifest.class), (Object)schemaVersion) != false ? "fsLayers" : "layers"))), var4_4[36].callGetProperty(DockerFacetUtils.class));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)var16_16, V2ManifestUtilImpl.class, (GroovyObject)v2Manifest, (String)"layers");
        var17_17 = v2Manifest;
        try {
            return var17_17;
        }
        catch (JsonProcessingException e) {
            var4_4[37].call(var4_4[38].callGroovyObjectGetProperty((Object)this), (Object)"Parsing manifest {} failed, due to processing exception", (Object)name, (Object)e);
            throw (Throwable)var4_4[39].callConstructor(V2Exception.ManifestInvalid.class, (Object)new GStringImpl(new Object[]{name, var4_4[40].call((Object)e)}, new String[]{"Corrupt manifest ", ": ", ""}));
        }
    }

    private String resolveMediaType(String contentType, Map<String, Object> manifest, MediaType mediaType) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        String type = contentType;
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)callSiteArray[41].callGetProperty(ContentTypes.class))) {
            Object object = callSiteArray[42].callGetPropertySafe(manifest);
            String manifestMediaType = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[43].callGetPropertySafe(callSiteArray[44].callGetProperty(manifest))));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].callSafe((Object)manifestMediaType, (Object)"application/vnd.docker"))) {
                Object object2 = callSiteArray[46].callGetProperty((Object)mediaType);
                type = ShortTypeHandling.castToString((Object)object2);
            } else {
                Object object3 = callSiteArray[47].callGetProperty((Object)mediaType);
                type = ShortTypeHandling.castToString((Object)object3);
            }
        }
        return type;
    }

    @Override
    @Transactional
    public Content mayDowngrade(Content manifestContent, String name, String tag, V2Manifest.SchemaVersion clientPreference, Repository repository) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        callSiteArray[48].call(callSiteArray[49].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade manifest check on {}:{}", (Object)name, (Object)tag);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest))) {
            StorageTx tx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call(UnitOfWork.class), StorageTx.class);
            callSiteArray[53].call(callSiteArray[54].callGroovyObjectGetProperty((Object)this), (Object)"Downgrading manifest on {}:{} based on client preference", (Object)name, (Object)tag);
            V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(V2ManifestSchema2.class, callSiteArray[56].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
            Bucket bucket = (Bucket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)tx, (Object)repository), Bucket.class);
            V2ManifestConfig config = (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callStatic(V2ManifestUtilImpl.class, (Object)tx, (Object)bucket, (Object)schemaV2), V2ManifestConfig.class);
            callSiteArray[59].callCurrent((GroovyObject)this, (Object)config, (Object)tx, (Object)bucket, callSiteArray[60].callGetProperty((Object)repository));
            V2ManifestSchema1 downgradedManifest = (V2ManifestSchema1)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].call((Object)this.v2ManifestConfigDowngrader, (Object)config, (Object)schemaV2, (Object)name, (Object)tag), V2ManifestSchema1.class);
            callSiteArray[62].call(callSiteArray[63].callGroovyObjectGetProperty((Object)this), (Object)"Downgraded manifest = {}", callSiteArray[64].call(JsonOutput.class, callSiteArray[65].call(JsonOutput.class, (Object)downgradedManifest)));
            Content content = (Content)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callConstructor(Content.class, callSiteArray[67].callConstructor(BytesPayload.class, callSiteArray[68].call((Object)MAPPER, (Object)downgradedManifest), callSiteArray[69].callGetProperty(V2ContentTypes.class))), Content.class);
            callSiteArray[70].call(callSiteArray[71].callGetProperty((Object)content), CacheInfo.class, callSiteArray[72].callConstructor(CacheInfo.class, callSiteArray[73].call(DateTime.class), null));
            return content;
        }
        callSiteArray[74].call(callSiteArray[75].callGroovyObjectGetProperty((Object)this), (Object)"Downgrade not needed on {}:{}", (Object)name, (Object)tag);
        return manifestContent;
    }

    @Override
    public DockerDigest manifestDigest(InputStreamSupplier manifestContent) throws IOException {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public class _manifestDigest_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _manifestDigest_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                String manifest = ShortTypeHandling.castToString((Object)callSiteArray[0].call(CharStreams.class, callSiteArray[1].callConstructor(InputStreamReader.class, (Object)inputStream, callSiteArray[2].callGetProperty(StandardCharsets.class))));
                Object object = callSiteArray[3].call(callSiteArray[4].call((Object)manifest, callSiteArray[5].call(callSiteArray[6].callGetProperty(V2ManifestUtilImpl.class), (Object)"\n\n"), (Object)"\n"), callSiteArray[7].callGetProperty(V2ManifestUtilImpl.class), (Object)"");
                manifest = ShortTypeHandling.castToString((Object)object);
                return callSiteArray[8].callConstructor(DockerDigest.class, callSiteArray[9].call(callSiteArray[10].callGetProperty(DockerFacetUtils.class)), callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callGetProperty(DockerFacetUtils.class)), (Object)manifest, callSiteArray[15].callGetProperty(StandardCharsets.class))));
            }

            public Object call(InputStream inputStream) {
                CallSite[] callSiteArray = _manifestDigest_closure2.$getCallSiteArray();
                return callSiteArray[16].callCurrent((GroovyObject)this, (Object)inputStream);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _manifestDigest_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "toString";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "UTF_8";
                stringArray[3] = "replaceAll";
                stringArray[4] = "replaceAll";
                stringArray[5] = "plus";
                stringArray[6] = "SIGNATURE_BLOCK";
                stringArray[7] = "SIGNATURE_BLOCK";
                stringArray[8] = "<$constructor$>";
                stringArray[9] = "name";
                stringArray[10] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[11] = "toString";
                stringArray[12] = "hashString";
                stringArray[13] = "function";
                stringArray[14] = "DOCKER_DIGEST_ALGORITHM";
                stringArray[15] = "UTF_8";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _manifestDigest_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_manifestDigest_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _manifestDigest_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(callSiteArray[77].call((Object)manifestContent), (Object)new _manifestDigest_closure2(this, this)), DockerDigest.class);
    }

    @Override
    public boolean shouldDowngrade(Content manifestContent, String name, V2Manifest.SchemaVersion clientPreference) throws IOException {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public class _shouldDowngrade_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _shouldDowngrade_closure3(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _shouldDowngrade_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _shouldDowngrade_closure3.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            public Content getManifestContent() {
                CallSite[] callSiteArray = _shouldDowngrade_closure3.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _shouldDowngrade_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldDowngrade_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_shouldDowngrade_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _shouldDowngrade_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _shouldDowngrade_closure3(this, this, manifestContent2)), InputStreamSupplier.class);
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[79].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callStatic(V2ManifestUtilImpl.class, (Object)clientPreference, (Object)manifest));
    }

    @Override
    public DockerDigest findConfigDigest(Content manifestContent, String name) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        V2Manifest manifest = (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callCurrent((GroovyObject)this, (Object)manifestContent, (Object)name), V2Manifest.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[82].callGroovyObjectGetProperty((Object)manifest), (Object)callSiteArray[83].callGetProperty(V2Manifest.SchemaVersion.class))) {
            throw (Throwable)callSiteArray[84].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[85].callGroovyObjectGetProperty((Object)manifest)}, new String[]{"Config file is not specified in schemaVersion: ", ""}));
        }
        V2ManifestSchema2 schemaV2 = (V2ManifestSchema2)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callConstructor(V2ManifestSchema2.class, callSiteArray[87].callGroovyObjectGetProperty((Object)manifest)), V2ManifestSchema2.class);
        return (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].call(DockerDigest.class, callSiteArray[89].callGetProperty(callSiteArray[90].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
    }

    @Override
    @Transactional
    public void validateManifest(Repository repository, String name, @Nullable String tag, V2Manifest v2Manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        List validationErrors = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(ArrayList.class), List.class);
        callSiteArray[92].call((Object)v2Manifest, (Object)validationErrors, (Object)name, (Object)tag);
        List digests = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call((Object)v2Manifest), List.class);
        StorageTx tx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call(UnitOfWork.class), StorageTx.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].call((Object)digests))) {
            DockerDigest digest = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call((Object)digests), Iterator.class);
            while (iterator.hasNext()) {
                digest = (DockerDigest)ScriptBytecodeAdapter.castToType(iterator.next(), DockerDigest.class);
                Asset layerAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callStatic(DockerFacetDatabaseUtils.class, (Object)tx, (Object)repository, callSiteArray[98].callStatic(DockerFacetUtils.class, (Object)digest)), Asset.class);
                Asset manifestAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callStatic(DockerFacetDatabaseUtils.class, (Object)tx, (Object)repository, callSiteArray[100].callStatic(DockerFacetUtils.class, (Object)name, (Object)digest)), Asset.class);
                if (!(ScriptBytecodeAdapter.compareEqual((Object)layerAsset, null) && ScriptBytecodeAdapter.compareEqual((Object)manifestAsset, null))) continue;
                callSiteArray[101].call(callSiteArray[102].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Manifest refers to missing layer: {} for: {}/{} in repository {}", (Object)digest, (Object)name, (Object)tag, (Object)repository));
                callSiteArray[103].call((Object)validationErrors, callSiteArray[104].call(callSiteArray[105].callGetProperty(V2Error.class), callSiteArray[106].call((Object)digest)));
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].call((Object)validationErrors))) {
            throw (Throwable)callSiteArray[108].callConstructor(V2Exception.class, (Object)"Invalid Manifest", callSiteArray[109].callGetProperty(HttpStatus.class), (Object)validationErrors);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void insertEmptyLayerIfNeeded(V2ManifestConfig config, StorageTx tx, Bucket bucket, Format format) {
        void var3_3;
        Reference tx2 = new Reference((Object)tx);
        Reference bucket2 = new Reference((Object)var3_3);
        Reference format2 = new Reference((Object)format);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public class _insertEmptyLayerIfNeeded_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _insertEmptyLayerIfNeeded_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(it), (Object)"empty_layer");
            }

            public Object doCall() {
                CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "keySet";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _insertEmptyLayerIfNeeded_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_insertEmptyLayerIfNeeded_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _insertEmptyLayerIfNeeded_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[110].call(callSiteArray[111].callGroovyObjectGetProperty((Object)config), (Object)new _insertEmptyLayerIfNeeded_closure4(this, this)))) {
            Object emptyBlobDigest = callSiteArray[112].call(DockerDigest.class, callSiteArray[113].callGroovyObjectGetProperty((Object)this));
            public class _insertEmptyLayerIfNeeded_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference tx;
                private /* synthetic */ Reference bucket;
                private /* synthetic */ Reference format;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _insertEmptyLayerIfNeeded_closure5(Object _outerInstance, Object _thisObject, Reference tx, Reference bucket, Reference format) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.tx = reference3 = tx;
                    this.bucket = reference2 = bucket;
                    this.format = reference = format;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    return callSiteArray[0].call(this.tx.get(), this.bucket.get(), this.format.get());
                }

                public StorageTx getTx() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    return (StorageTx)ScriptBytecodeAdapter.castToType((Object)this.tx.get(), StorageTx.class);
                }

                public Bucket getBucket() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    return (Bucket)ScriptBytecodeAdapter.castToType((Object)this.bucket.get(), Bucket.class);
                }

                public Format getFormat() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    return (Format)ScriptBytecodeAdapter.castToType((Object)this.format.get(), Format.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "createAsset";
                    return new CallSiteArray(_insertEmptyLayerIfNeeded_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _insertEmptyLayerIfNeeded_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[114].call(DockerFacetDatabaseUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)((Bucket)bucket2.get()), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Supplier)ScriptBytecodeAdapter.asType((Object)((Object)new _insertEmptyLayerIfNeeded_closure5(this, this, tx2, bucket2, format2)), Supplier.class)), Supplier.class), (Object)callSiteArray[115].call(DockerFacetUtils.class, emptyBlobDigest), (Object)emptyBlobDigest)), Asset.class);
            public class _insertEmptyLayerIfNeeded_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _insertEmptyLayerIfNeeded_closure6(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return callSiteArray[0].callConstructor(ByteArrayInputStream.class, callSiteArray[1].callGetProperty(V2ManifestUtilImpl.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _insertEmptyLayerIfNeeded_closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _insertEmptyLayerIfNeeded_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "EMPTY_BLOB_BYTES";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _insertEmptyLayerIfNeeded_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_insertEmptyLayerIfNeeded_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _insertEmptyLayerIfNeeded_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _insertEmptyLayerIfNeeded_closure6(this, this)), InputStreamSupplier.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[116].call((Object)asset), null)) {
                Object formatAttributes = callSiteArray[117].call((Object)asset);
                callSiteArray[118].call(formatAttributes, callSiteArray[119].callGetProperty(AssetEntityAdapter.class), callSiteArray[120].call(callSiteArray[121].callGetProperty(AssetKind.class)));
                callSiteArray[122].call(DockerFacetDatabaseUtils.class, ArrayUtil.createArray((Object)((StorageTx)tx2.get()), (Object)asset, (Object)inputStreamSupplier, (Object)emptyBlobDigest, (Object)callSiteArray[123].callGetProperty(V2ContentTypes.class), null));
            }
        }
    }

    public static V2ManifestConfig loadConfigurationFile(StorageTx tx, Bucket bucket, V2ManifestSchema2 schemaV2) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        DockerDigest digest = (DockerDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].call(DockerDigest.class, callSiteArray[125].callGetProperty(callSiteArray[126].callGroovyObjectGetProperty((Object)schemaV2))), DockerDigest.class);
        Asset configAsset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].call(DockerFacetDatabaseUtils.class, (Object)tx, (Object)bucket, (Object)digest), Asset.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)configAsset, null)) {
            throw (Throwable)callSiteArray[128].callConstructor(V2Exception.BlobNotFound.class, (Object)digest);
        }
        return (V2ManifestConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].call((Object)MAPPER, callSiteArray[130].callGetProperty(callSiteArray[131].call((Object)tx, callSiteArray[132].call((Object)configAsset))), V2ManifestConfig.class), V2ManifestConfig.class);
    }

    private V2Manifest readManifestContent(Content manifestContent, String name) {
        Reference manifestContent2 = new Reference((Object)manifestContent);
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        public class _readManifestContent_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference manifestContent;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _readManifestContent_closure7(Object _outerInstance, Object _thisObject, Reference manifestContent) {
                Reference reference;
                CallSite[] callSiteArray = _readManifestContent_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.manifestContent = reference = manifestContent;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _readManifestContent_closure7.$getCallSiteArray();
                return callSiteArray[0].call(this.manifestContent.get());
            }

            public Content getManifestContent() {
                CallSite[] callSiteArray = _readManifestContent_closure7.$getCallSiteArray();
                return (Content)ScriptBytecodeAdapter.castToType((Object)this.manifestContent.get(), Content.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _readManifestContent_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readManifestContent_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "openInputStream";
                return new CallSiteArray(_readManifestContent_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readManifestContent_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        InputStreamSupplier inputStreamSupplier = (InputStreamSupplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _readManifestContent_closure7(this, this, manifestContent2)), InputStreamSupplier.class);
        return (V2Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callCurrent((GroovyObject)this, (Object)inputStreamSupplier, (Object)name, callSiteArray[134].callGetProperty((Object)((Content)manifestContent2.get()))), V2Manifest.class);
    }

    private static boolean downgradeRequired(V2Manifest.SchemaVersion clientPreference, V2Manifest manifest) {
        CallSite[] callSiteArray = V2ManifestUtilImpl.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[135].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[136].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[137].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[138].call(callSiteArray[139].callGetProperty(MediaType.class), callSiteArray[140].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[141].call(callSiteArray[142].callGetProperty(V2ContentTypes.class), callSiteArray[143].callGroovyObjectGetProperty((Object)manifest)));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[144].callGetProperty(V2Manifest.SchemaVersion.class), (Object)((Object)clientPreference)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[145].callGetProperty(V2Manifest.SchemaVersion.class), (Object)callSiteArray[146].callGroovyObjectGetProperty((Object)manifest)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[147].call(callSiteArray[148].callGetProperty(MediaType.class), callSiteArray[149].callGroovyObjectGetProperty((Object)manifest))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].call(callSiteArray[151].callGetProperty(V2ContentTypes.class), callSiteArray[152].callGroovyObjectGetProperty((Object)manifest)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != V2ManifestUtilImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static ObjectMapper getMAPPER() {
        return MAPPER;
    }

    public V2ManifestConfigDowngrader getV2ManifestConfigDowngrader() {
        return this.v2ManifestConfigDowngrader;
    }

    public void setV2ManifestConfigDowngrader(V2ManifestConfigDowngrader v2ManifestConfigDowngrader) {
        this.v2ManifestConfigDowngrader = v2ManifestConfigDowngrader;
    }

    public DockerAssetSearch getDockerAssetSearch() {
        return this.dockerAssetSearch;
    }

    public void setDockerAssetSearch(DockerAssetSearch dockerAssetSearch) {
        this.dockerAssetSearch = dockerAssetSearch;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "enable";
        stringArray[2] = "INDENT_OUTPUT";
        stringArray[3] = "checkNotNull";
        stringArray[4] = "checkNotNull";
        stringArray[5] = "debug";
        stringArray[6] = "log";
        stringArray[7] = "withStream";
        stringArray[8] = "get";
        stringArray[9] = "getAt";
        stringArray[10] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[11] = "containsKey";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "Schema1";
        stringArray[14] = "V2_MANIFEST_SCHEMA_1_SIGNED";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "Schema1";
        stringArray[17] = "V2_MANIFEST_SCHEMA_1";
        stringArray[18] = "V2_MANIFEST_SCHEMA2_VERSION";
        stringArray[19] = "containsKey";
        stringArray[20] = "matches";
        stringArray[21] = "IMAGE_INDEX";
        stringArray[22] = "get";
        stringArray[23] = "resolveMediaType";
        stringArray[24] = "IMAGE_INDEX";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "Schema2";
        stringArray[27] = "resolveMediaType";
        stringArray[28] = "IMAGE_MANIFEST";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "Schema2";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "readValue";
        stringArray[33] = "writeValueAsString";
        stringArray[34] = "get";
        stringArray[35] = "V2_MANIFEST_SCHEMA1_VERSION";
        stringArray[36] = "DOCKER_LAYERS_TYPE_REF";
        stringArray[37] = "debug";
        stringArray[38] = "log";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "getMessage";
        stringArray[41] = "APPLICATION_JSON";
        stringArray[42] = "mediaType";
        stringArray[43] = "mediaType";
        stringArray[44] = "config";
        stringArray[45] = "startsWith";
        stringArray[46] = "dockerMediaType";
        stringArray[47] = "ociMediaType";
        stringArray[48] = "debug";
        stringArray[49] = "log";
        stringArray[50] = "readManifestContent";
        stringArray[51] = "downgradeRequired";
        stringArray[52] = "currentTx";
        stringArray[53] = "debug";
        stringArray[54] = "log";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "manifest";
        stringArray[57] = "findBucket";
        stringArray[58] = "loadConfigurationFile";
        stringArray[59] = "insertEmptyLayerIfNeeded";
        stringArray[60] = "format";
        stringArray[61] = "downgrade";
        stringArray[62] = "debug";
        stringArray[63] = "log";
        stringArray[64] = "prettyPrint";
        stringArray[65] = "toJson";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "writeValueAsBytes";
        stringArray[69] = "V2_MANIFEST_SCHEMA_1";
        stringArray[70] = "set";
        stringArray[71] = "attributes";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "now";
        stringArray[74] = "debug";
        stringArray[75] = "log";
        stringArray[76] = "withCloseable";
        stringArray[77] = "get";
        stringArray[78] = "readManifest";
        stringArray[79] = "contentType";
        stringArray[80] = "downgradeRequired";
        stringArray[81] = "readManifestContent";
        stringArray[82] = "schemaVersion";
        stringArray[83] = "Schema2";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "schemaVersion";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "manifest";
        stringArray[88] = "parse";
        stringArray[89] = "digest";
        stringArray[90] = "config";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "validateManifest";
        stringArray[93] = "referencedDigests";
        stringArray[94] = "currentTx";
        stringArray[95] = "isEmpty";
        stringArray[96] = "iterator";
        stringArray[97] = "findAsset";
        stringArray[98] = "blobName";
        stringArray[99] = "findAsset";
        stringArray[100] = "manifestName";
        stringArray[101] = "error";
        stringArray[102] = "log";
        stringArray[103] = "add";
        stringArray[104] = "withDetail";
        stringArray[105] = "BLOB_UNKNOWN";
        stringArray[106] = "toString";
        stringArray[107] = "isEmpty";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "BAD_REQUEST";
        stringArray[110] = "any";
        stringArray[111] = "history";
        stringArray[112] = "parse";
        stringArray[113] = "EMPTY_BLOB_DIGEST";
        stringArray[114] = "getOrCreateAsset";
        stringArray[115] = "blobName";
        stringArray[116] = "blobRef";
        stringArray[117] = "formatAttributes";
        stringArray[118] = "set";
        stringArray[119] = "P_ASSET_KIND";
        stringArray[120] = "name";
        stringArray[121] = "BLOB";
        stringArray[122] = "saveAsset";
        stringArray[123] = "V2_BLOB_IMAGE_LAYER";
        stringArray[124] = "parse";
        stringArray[125] = "digest";
        stringArray[126] = "config";
        stringArray[127] = "findAssetByContentDigest";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "readValue";
        stringArray[130] = "inputStream";
        stringArray[131] = "requireBlob";
        stringArray[132] = "requireBlobRef";
        stringArray[133] = "readManifest";
        stringArray[134] = "contentType";
        stringArray[135] = "Schema1";
        stringArray[136] = "Schema2";
        stringArray[137] = "schemaVersion";
        stringArray[138] = "matches";
        stringArray[139] = "IMAGE_INDEX";
        stringArray[140] = "mediaType";
        stringArray[141] = "equals";
        stringArray[142] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[143] = "mediaType";
        stringArray[144] = "Schema1";
        stringArray[145] = "Schema2";
        stringArray[146] = "schemaVersion";
        stringArray[147] = "matches";
        stringArray[148] = "IMAGE_INDEX";
        stringArray[149] = "mediaType";
        stringArray[150] = "equals";
        stringArray[151] = "OCI_IMAGE_MANIFEST_V1";
        stringArray[152] = "mediaType";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[153];
        V2ManifestUtilImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(V2ManifestUtilImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = V2ManifestUtilImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

