/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.OrientReplicationIngestionService;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Named
public class OrientDockerReplicationFacet
extends OrientReplicationFacetSupport {
    public static final TokenParser manifestPathParser = new TokenParser("v2/{name:.+}/manifests/{tag}");
    private final OrientReplicationIngestionService ingestionService;

    @Inject
    public OrientDockerReplicationFacet(OrientReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        Map parsedPath = manifestPathParser.parse(path);
        if (parsedPath != null) {
            String name = (String)parsedPath.get("name");
            String tag = (String)parsedPath.get("tag");
            if (tag.contains(":")) {
                this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob);
            } else {
                Component component = this.ingestionService.replicateComponent(this.getRepository(), name, tag, null, componentAttributes);
                this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob, component);
            }
        } else {
            this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob);
        }
    }

    public boolean doReplicateDelete(String path) {
        return this.ingestionService.replicateDeleteAsset(this.getRepository(), path);
    }
}

