/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.orient;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.orient.DockerAssetSearchSupport;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DockerAssetSearch
extends DockerAssetSearchSupport {
    private final ElasticSearchQueryService elasticSearchQueryService;

    @Inject
    public DockerAssetSearch(ElasticSearchQueryService elasticSearchQueryService) {
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
    }

    @Nullable
    public Set<String> findByContentDigest(DockerDigest digest, String repositoryName) {
        Iterable hits;
        TreeSet<String> assets = new TreeSet<String>();
        UnitOfWork paused = UnitOfWork.pause();
        try {
            hits = this.elasticSearchQueryService.browse((QueryBuilder)RepositoryQueryBuilder.unrestricted((QueryBuilder)QueryBuilders.matchQuery((String)"assets.attributes.docker.content_digest", (Object)digest.toString())).inRepositories(new String[]{repositoryName}));
        }
        finally {
            UnitOfWork.resume((UnitOfWork)paused);
        }
        for (SearchHit hit : hits) {
            Map<String, Object> matchingAsset = this.getSearchAssetMatchingContentDigest(hit, digest);
            if (matchingAsset == null) continue;
            assets.add((String)matchingAsset.get("name"));
        }
        return assets;
    }
}

