/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerProxyFacetSupport;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.docker.internal.datastore.V1Handlers;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class DockerProxyFacetImpl
extends DockerProxyFacetSupport {
    @Inject
    public DockerProxyFacetImpl(V2ManifestUtil v2ManifestUtil, ConstraintViolationFactory constraintViolationFactory, @Named(value="${nexus.docker.proxy.verifyManifestDigest:-true}") boolean verifyManifestDigest) {
        super(v2ManifestUtil, constraintViolationFactory, verifyManifestDigest);
    }

    protected Content getCachedContent(Context context) throws IOException {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case IMAGES: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context))))).orElse(null);
            }
            case TAGS: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1tagsName(V1Handlers.name(V2Handlers.matcherState(context))))).orElse(null);
            }
            case TAG: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1tagName(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context))))).orElse(null);
            }
            case LAYER_METADATA: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(V1Handlers.layerId(V2Handlers.matcherState(context))))).orElse(null);
            }
            case LAYER_CONTENT: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerContentName(V1Handlers.layerId(V2Handlers.matcherState(context))))).orElse(null);
            }
            case LAYER_ANCESTRY: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerAncestryName(V1Handlers.layerId(V2Handlers.matcherState(context))))).orElse(null);
            }
            case SEARCH: {
                return null;
            }
            case MANIFEST: {
                return this.getManifest(context);
            }
            case BLOB: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))))).orElse(null);
            }
            case TAG_LIST: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context))))).orElse(null);
            }
            case CATALOG: {
                return this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.catalogName())).orElse(null);
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        try {
            return this.storeByAssetKind(context, content, assetKind);
        }
        catch (V1Exception e) {
            String remoteUrl = this.getRemoteUrl().toString();
            throw new V1Exception.InvalidResponseFromRemote(e, remoteUrl, context.getRequest().getPath());
        }
    }

    @Override
    protected List<String> getForeignLayerUrls(String digest) throws JsonProcessingException {
        return this.content().getForeignLayerUrls(digest);
    }

    @Override
    protected void updateForeignLayerUrls(String digest, List<String> urls) throws JsonProcessingException {
        this.content().updateForeignLayerUrls(digest, urls);
    }

    @Override
    protected DockerDigest manifestDigestFromContent(Content contentByHash) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)contentByHash, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.v2ManifestUtil.manifestDigest((InputStreamSupplier)blob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content storeByAssetKind(Context context, Content content, AssetKind assetKind) throws IOException {
        switch (assetKind) {
            case IMAGES: {
                return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1imagesIndexName(V1Handlers.name(V2Handlers.matcherState(context)))), (Payload)content, assetKind, new HashMap<String, Object>());
            }
            case TAGS: {
                return this.putTags(V1Handlers.name(V2Handlers.matcherState(context)), content);
            }
            case TAG: {
                return this.putTag(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.tag(V2Handlers.matcherState(context)), content);
            }
            case LAYER_METADATA: {
                return this.putLayerMetadata(V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case LAYER_CONTENT: {
                String layerId = V1Handlers.layerId(V2Handlers.matcherState(context));
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("layerId", layerId);
                return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerContentName(layerId)), (Payload)content, assetKind, attributes);
            }
            case LAYER_ANCESTRY: {
                return this.putAncestry(V1Handlers.name(V2Handlers.matcherState(context)), V1Handlers.layerId(V2Handlers.matcherState(context)), content);
            }
            case SEARCH: {
                return content;
            }
            case MANIFEST: {
                return this.putManifest(context, content);
            }
            case BLOB: {
                V2Handlers.requireName(V2Handlers.matcherState(context), false);
                return this.putAssetValidatedOnDigest(DockerFacetUtils.blobName(V2Handlers.requireDigest(V2Handlers.matcherState(context))), context, content, assetKind, new HashMap<String, Object>());
            }
            case TAG_LIST: {
                return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.tagListName(V2Handlers.requireName(V2Handlers.matcherState(context)))), (Payload)content, assetKind, new HashMap<String, Object>());
            }
            case CATALOG: {
                return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.catalogName()), (Payload)content, assetKind, new HashMap<String, Object>());
            }
        }
        throw new IllegalStateException();
    }

    private Content putTags(String name, Content content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            Map<String, String> tags = DockerFacetUtils.readTags((InputStreamSupplier)blob);
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                this.doPutLayerIdJson(name, entry);
            }
            return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1tagsName(name)), blob, (Payload)content, AssetKind.TAG_LIST, new HashMap<String, Object>());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putTag(String name, String tag, Content content) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutTag(name, tag, blob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content doPutTag(String name, String tag, TempBlob tagContent, Content payload) throws IOException {
        String layerId = DockerFacetUtils.readLayerId((InputStreamSupplier)tagContent);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("layerId", layerId);
        return this.content().putTag(name, tag, (Payload)new Content(payload, (Payload)new TempBlobPayload(tagContent)), attributes, attributes);
    }

    private void doPutLayerIdJson(String name, Map.Entry<String, String> entry) throws IOException {
        String layerIdJson = String.valueOf('\"') + entry.getValue() + '\"';
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(layerIdJson.getBytes(StandardCharsets.UTF_8));){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (TempBlob blob = this.content().blobs().ingest((InputStream)in, "application/json", DockerFacetUtils.HASH_ALGORITHMS);){
                this.doPutTag(name, entry.getKey(), blob, new Content((Payload)new StringPayload(layerIdJson, "application/json")));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Content putAncestry(String name, String layerId, Content content) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            List<String> ancestry = DockerFacetUtils.readAncestry((InputStreamSupplier)blob);
            this.content().putAncestry(name, layerId, ancestry);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerAncestryName(layerId)), blob, (Payload)content, AssetKind.LAYER_ANCESTRY, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putLayerMetadata(String layerId, Content content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("layerId", layerId);
            attributes.put("parent", DockerFacetUtils.readLayerMetadata((InputStreamSupplier)blob).get("parent"));
            return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId)), blob, (Payload)content, AssetKind.LAYER_METADATA, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putAssetValidatedOnDigest(String name, Context context, Content content, AssetKind assetKind, Map<String, Object> attributes) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob blob = this.content().blobs().ingest((Payload)content, DockerFacetUtils.HASH_ALGORITHMS);){
            this.maybeValidateOnDigest(V2Handlers.matcherState(context), blob);
            return this.content().putHardLinkedBlob(DockerFacetDatabaseUtils.assetPath(name), blob, (Payload)content, assetKind, attributes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content getManifest(Context context) throws IOException {
        TokenMatcher.State state = V2Handlers.matcherState(context);
        String name = V2Handlers.requireName(state);
        String tag = V2Handlers.tag(state);
        V2Manifest.SchemaVersion schemaVersion = V2Handlers.detectClientSchemaVersionPreference(context);
        Content manifest = tag != null ? (Content)this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.tagName(name, tag))).orElse(null) : (Content)this.content().get(DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.manifestName(name, V2Handlers.requireDigest(state)))).orElse(null);
        if (manifest != null && schemaVersion == V2Manifest.SchemaVersion.Schema2 && DockerFacetUtils.isTrue(this.config.cacheForeignLayers)) {
            this.identifyForeignLayers(manifest);
        }
        return manifest;
    }

    private Content putManifest(Context context, Content content) throws IOException {
        String tag = V2Handlers.tag(V2Handlers.matcherState(context));
        if (!Strings.isNullOrEmpty((String)tag)) {
            return this.putManifestByTag(V2Handlers.requireName(V2Handlers.matcherState(context)), tag, context, content);
        }
        return this.putManifestByDigest(V2Handlers.requireName(V2Handlers.matcherState(context)), V2Handlers.requireDigest(V2Handlers.matcherState(context)), content);
    }

    private Content putManifestByDigest(String name, DockerDigest digest, Content content) throws IOException {
        String contentType = content.getContentType() == null ? "application/json" : content.getContentType();
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob blob = this.content().blobs().ingest(content.openInputStream(), contentType, DockerFacetUtils.HASH_ALGORITHMS);){
            return this.doPutManifestByDigest(name, digest, blob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content doPutManifestByDigest(String name, DockerDigest digest, TempBlob manifestContent, Content content) throws IOException {
        DockerDigest manifestDigest = this.v2ManifestUtil.manifestDigest((InputStreamSupplier)manifestContent);
        if (this.verifyManifestDigest && !manifestDigest.equals(digest)) {
            throw new V2Exception.DigestInvalidByMismatch();
        }
        return this.content().putManifestByDigest(name, manifestDigest, (Payload)new Content(content, (Payload)new TempBlobPayload(manifestContent)));
    }

    private Content putManifestByTag(String name, String tag, Context context, Content content) throws IOException {
        String contentType = content.getContentType() == null ? "application/json" : content.getContentType();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob blob = this.content().blobs().ingest(content.openInputStream(), contentType, DockerFacetUtils.HASH_ALGORITHMS);){
            DockerDigest manifestDigest = this.fetchTagDigestByContentDigest(context, tag, content.getAttributes(), blob);
            Content digestContent = this.doPutManifestByDigest(name, manifestDigest, blob, content);
            return this.doPutManifestByTag(name, tag, manifestDigest, digestContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content doPutManifestByTag(String name, String tag, DockerDigest manifestDigest, Content content) {
        return this.content().putManifestByTag(name, tag, manifestDigest, (Payload)content);
    }

    private DockerContentFacet content() {
        return (DockerContentFacet)this.getRepository().facet(DockerContentFacet.class);
    }
}

