/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal.datastore.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.docker.UploadManager;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.DockerHostedFacet;
import org.sonatype.nexus.repository.docker.internal.InvalidUploadRangeException;
import org.sonatype.nexus.repository.docker.internal.Upload;
import org.sonatype.nexus.repository.docker.internal.UploadCompletion;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.V2CatalogResult;
import org.sonatype.nexus.repository.docker.internal.V2Exception;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public abstract class DockerHostedFacetSupport
extends FacetSupport
implements DockerHostedFacet {
    private final UploadManager uploadManager;

    public DockerHostedFacetSupport(int uploadLockSize) {
        Preconditions.checkArgument((uploadLockSize > 0 ? 1 : 0) != 0, (String)"nexus.docker.upload.lock.size must be a positive integer found %s", (int)uploadLockSize);
        this.uploadManager = this.createUploadManager(uploadLockSize);
    }

    public DockerHostedFacetSupport(UploadManager uploadManager) {
        this.uploadManager = uploadManager;
    }

    protected abstract UploadManager createUploadManager(int var1);

    @Override
    public void putLayerChecksum(String layerId, String checksum) {
        DockerFacetUtils.validateLayerId(layerId);
        if (checksum == null) {
            throw new V1Exception.OldDocker("X-Docker-Checksum-Payload not set");
        }
        if (StringUtils.isBlank((String)checksum)) {
            throw new V1Exception.InvalidChecksum("Missing Image's checksum");
        }
        if (checksum.split(":").length != 2) {
            throw new V1Exception.InvalidChecksum("Invalid checksum format");
        }
        this.doPutLayerChecksum(layerId, checksum);
    }

    protected abstract void doPutLayerChecksum(String var1, String var2);

    @Override
    public String beginBlobUpload(String name) throws IOException {
        Upload upload = this.uploadManager.startUpload(name);
        return upload.getUuid();
    }

    @Override
    public Range<Long> uploadBlobRange(String name, String uuid, Optional<Range<Long>> range, Payload payload) throws IOException {
        try {
            return this.uploadManager.add(name, uuid, range, payload);
        }
        catch (InvalidUploadRangeException e) {
            throw new V2Exception.RangeInvalid(e.getMessage());
        }
    }

    @Override
    public UploadCompletion completeBlobUpload(String name, String uuid, DockerDigest digest, Optional<Range<Long>> range, Payload payload) throws IOException {
        Upload upload = this.upload(name, uuid, payload, range);
        Content content = this.saveUploadToAsset(upload, digest);
        this.uploadManager.cancel(uuid);
        return this.createUploadCompletion(name, digest, content, upload);
    }

    @Override
    public UploadCompletion completeBlobUpload(File blobLocation, String name, String uuid, DockerDigest digest, Payload payload) throws IOException {
        Upload upload = this.upload(name, uuid, payload, Optional.empty());
        Content content = this.saveUploadToAssetViaHardLink(blobLocation, upload, digest);
        this.uploadManager.cancel(uuid);
        return this.createUploadCompletion(name, digest, content, upload);
    }

    protected abstract UploadCompletion createUploadCompletion(String var1, DockerDigest var2, Content var3, Upload var4);

    protected abstract Content saveUploadToAsset(Upload var1, DockerDigest var2) throws IOException;

    protected abstract Content saveUploadToAssetViaHardLink(File var1, Upload var2, DockerDigest var3) throws IOException;

    @Override
    public void deleteUpload(String name, String uuid) throws IOException {
        try {
            this.uploadManager.cancel(uuid);
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to cancel upload", (Throwable)e);
            throw new V2Exception.BlobUploadUnknown(e.getMessage());
        }
    }

    @Override
    public void purgeUploads(Duration age) {
        this.uploadManager.purgeUploads(age);
    }

    @Override
    public long getBlobUploadProgress(String name, String uuid) throws IOException {
        try {
            return this.uploadManager.offset(name, uuid);
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to evaluate upload progress", (Throwable)e);
            throw new V2Exception.BlobUploadUnknown(e.getMessage());
        }
    }

    @Override
    public Content getCatalog() throws IOException {
        V2CatalogResult catalog = new V2CatalogResult();
        Iterables.addAll(catalog.getRepositories(), this.getUniqueComponentNames());
        return new Content((Payload)new StringPayload(DockerFacetUtils.mapper.writeValueAsString((Object)catalog), "application/json"));
    }

    protected abstract Iterable<String> getUniqueComponentNames();

    private Upload upload(String name, String uuid, Payload payload, Optional<Range<Long>> range) throws IOException {
        try {
            return this.uploadManager.complete(name, uuid, range, payload);
        }
        catch (InvalidUploadRangeException e) {
            throw new V2Exception.RangeInvalid(e.getMessage());
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to complete upload", (Throwable)e);
            throw new V2Exception.BlobUploadUnknown(e.getMessage());
        }
    }
}

